/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TargetConfigurationRequest
implements ToCopyableBuilder<Builder, TargetConfigurationRequest> {
    private final Integer instanceCount;
    private final String offeringId;

    private TargetConfigurationRequest(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.offeringId = builder.offeringId;
    }

    public Integer instanceCount() {
        return this.instanceCount;
    }

    public String offeringId() {
        return this.offeringId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceCount() == null ? 0 : this.instanceCount().hashCode());
        hashCode = 31 * hashCode + (this.offeringId() == null ? 0 : this.offeringId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetConfigurationRequest)) {
            return false;
        }
        TargetConfigurationRequest other = (TargetConfigurationRequest)obj;
        if (other.instanceCount() == null ^ this.instanceCount() == null) {
            return false;
        }
        if (other.instanceCount() != null && !other.instanceCount().equals(this.instanceCount())) {
            return false;
        }
        if (other.offeringId() == null ^ this.offeringId() == null) {
            return false;
        }
        return other.offeringId() == null || other.offeringId().equals(this.offeringId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceCount() != null) {
            sb.append("InstanceCount: ").append(this.instanceCount()).append(",");
        }
        if (this.offeringId() != null) {
            sb.append("OfferingId: ").append(this.offeringId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetConfigurationRequest model) {
            this.setInstanceCount(model.instanceCount);
            this.setOfferingId(model.offeringId);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        public TargetConfigurationRequest build() {
            return new TargetConfigurationRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetConfigurationRequest> {
        public Builder instanceCount(Integer var1);

        public Builder offeringId(String var1);
    }
}

