/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.KeyNameStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeKeyPairsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeKeyPairsRequest> {
    private final List<Filter> filters;
    private final List<String> keyNames;

    private DescribeKeyPairsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.keyNames = builder.keyNames;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> keyNames() {
        return this.keyNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.keyNames() == null ? 0 : this.keyNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsRequest)) {
            return false;
        }
        DescribeKeyPairsRequest other = (DescribeKeyPairsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.keyNames() == null ^ this.keyNames() == null) {
            return false;
        }
        return other.keyNames() == null || other.keyNames().equals(this.keyNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.keyNames() != null) {
            sb.append("KeyNames: ").append(this.keyNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> keyNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsRequest model) {
            this.setFilters(model.filters);
            this.setKeyNames(model.keyNames);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        public final Collection<String> getKeyNames() {
            return this.keyNames;
        }

        @Override
        public final Builder keyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyNames(String ... keyNames) {
            this.keyNames(Arrays.asList(keyNames));
            return this;
        }

        public final void setKeyNames(Collection<String> keyNames) {
            this.keyNames = KeyNameStringListCopier.copy(keyNames);
        }

        public DescribeKeyPairsRequest build() {
            return new DescribeKeyPairsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeKeyPairsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder keyNames(Collection<String> var1);

        public Builder keyNames(String ... var1);
    }
}

