/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopySnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopySnapshotRequest> {
    private final String description;
    private final String destinationRegion;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String presignedUrl;
    private final String sourceRegion;
    private final String sourceSnapshotId;

    private CopySnapshotRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.destinationRegion = builder.destinationRegion;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.presignedUrl = builder.presignedUrl;
        this.sourceRegion = builder.sourceRegion;
        this.sourceSnapshotId = builder.sourceSnapshotId;
    }

    public String description() {
        return this.description;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String presignedUrl() {
        return this.presignedUrl;
    }

    public String sourceRegion() {
        return this.sourceRegion;
    }

    public String sourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.destinationRegion() == null ? 0 : this.destinationRegion().hashCode());
        hashCode = 31 * hashCode + (this.encrypted() == null ? 0 : this.encrypted().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.presignedUrl() == null ? 0 : this.presignedUrl().hashCode());
        hashCode = 31 * hashCode + (this.sourceRegion() == null ? 0 : this.sourceRegion().hashCode());
        hashCode = 31 * hashCode + (this.sourceSnapshotId() == null ? 0 : this.sourceSnapshotId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest)((Object)obj);
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.destinationRegion() == null ^ this.destinationRegion() == null) {
            return false;
        }
        if (other.destinationRegion() != null && !other.destinationRegion().equals(this.destinationRegion())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.presignedUrl() == null ^ this.presignedUrl() == null) {
            return false;
        }
        if (other.presignedUrl() != null && !other.presignedUrl().equals(this.presignedUrl())) {
            return false;
        }
        if (other.sourceRegion() == null ^ this.sourceRegion() == null) {
            return false;
        }
        if (other.sourceRegion() != null && !other.sourceRegion().equals(this.sourceRegion())) {
            return false;
        }
        if (other.sourceSnapshotId() == null ^ this.sourceSnapshotId() == null) {
            return false;
        }
        return other.sourceSnapshotId() == null || other.sourceSnapshotId().equals(this.sourceSnapshotId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.destinationRegion() != null) {
            sb.append("DestinationRegion: ").append(this.destinationRegion()).append(",");
        }
        if (this.encrypted() != null) {
            sb.append("Encrypted: ").append(this.encrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.presignedUrl() != null) {
            sb.append("PresignedUrl: ").append(this.presignedUrl()).append(",");
        }
        if (this.sourceRegion() != null) {
            sb.append("SourceRegion: ").append(this.sourceRegion()).append(",");
        }
        if (this.sourceSnapshotId() != null) {
            sb.append("SourceSnapshotId: ").append(this.sourceSnapshotId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private String destinationRegion;
        private Boolean encrypted;
        private String kmsKeyId;
        private String presignedUrl;
        private String sourceRegion;
        private String sourceSnapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            this.setDescription(model.description);
            this.setDestinationRegion(model.destinationRegion);
            this.setEncrypted(model.encrypted);
            this.setKmsKeyId(model.kmsKeyId);
            this.setPresignedUrl(model.presignedUrl);
            this.setSourceRegion(model.sourceRegion);
            this.setSourceSnapshotId(model.sourceSnapshotId);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPresignedUrl() {
            return this.presignedUrl;
        }

        @Override
        public final Builder presignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
            return this;
        }

        public final void setPresignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceSnapshotId() {
            return this.sourceSnapshotId;
        }

        @Override
        public final Builder sourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        public final void setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
        }

        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopySnapshotRequest> {
        public Builder description(String var1);

        public Builder destinationRegion(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder presignedUrl(String var1);

        public Builder sourceRegion(String var1);

        public Builder sourceSnapshotId(String var1);
    }
}

