/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.AccountAttributeValue;
import software.amazon.awssdk.services.ec2.model.AccountAttributeValueListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AccountAttribute
implements ToCopyableBuilder<Builder, AccountAttribute> {
    private final String attributeName;
    private final List<AccountAttributeValue> attributeValues;

    private AccountAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValues = builder.attributeValues;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public List<AccountAttributeValue> attributeValues() {
        return this.attributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        hashCode = 31 * hashCode + (this.attributeValues() == null ? 0 : this.attributeValues().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAttribute)) {
            return false;
        }
        AccountAttribute other = (AccountAttribute)obj;
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        if (other.attributeName() != null && !other.attributeName().equals(this.attributeName())) {
            return false;
        }
        if (other.attributeValues() == null ^ this.attributeValues() == null) {
            return false;
        }
        return other.attributeValues() == null || other.attributeValues().equals(this.attributeValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (this.attributeValues() != null) {
            sb.append("AttributeValues: ").append(this.attributeValues()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private List<AccountAttributeValue> attributeValues;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAttribute model) {
            this.setAttributeName(model.attributeName);
            this.setAttributeValues(model.attributeValues);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public final Collection<AccountAttributeValue> getAttributeValues() {
            return this.attributeValues;
        }

        @Override
        public final Builder attributeValues(Collection<AccountAttributeValue> attributeValues) {
            this.attributeValues = AccountAttributeValueListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(AccountAttributeValue ... attributeValues) {
            this.attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        public final void setAttributeValues(Collection<AccountAttributeValue> attributeValues) {
            this.attributeValues = AccountAttributeValueListCopier.copy(attributeValues);
        }

        public AccountAttribute build() {
            return new AccountAttribute(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AccountAttribute> {
        public Builder attributeName(String var1);

        public Builder attributeValues(Collection<AccountAttributeValue> var1);

        public Builder attributeValues(AccountAttributeValue ... var1);
    }
}

