/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        List<String> modifyImageAttributeRequestUserIdsList;
        List<String> modifyImageAttributeRequestUserGroupsList;
        List<String> modifyImageAttributeRequestProductCodesList;
        LaunchPermissionModifications launchPermission;
        if (modifyImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyImageAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyImageAttributeRequest.attribute()));
        }
        if (modifyImageAttributeRequest.description() != null) {
            request.addParameter("Description.Value", StringUtils.fromString((String)modifyImageAttributeRequest.description()));
        }
        if (modifyImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)modifyImageAttributeRequest.imageId()));
        }
        if ((launchPermission = modifyImageAttributeRequest.launchPermission()) != null) {
            List<LaunchPermission> launchPermissionModificationsRemoveList;
            List<LaunchPermission> launchPermissionModificationsAddList = launchPermission.add();
            if (launchPermissionModificationsAddList != null) {
                int addListIndex = 1;
                for (LaunchPermission launchPermission2 : launchPermissionModificationsAddList) {
                    if (launchPermission2.group() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)launchPermission2.group()));
                    }
                    if (launchPermission2.userId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)launchPermission2.userId()));
                    }
                    ++addListIndex;
                }
            }
            if ((launchPermissionModificationsRemoveList = launchPermission.remove()) != null) {
                int removeListIndex = 1;
                for (LaunchPermission launchPermissionModificationsRemoveListValue : launchPermissionModificationsRemoveList) {
                    if (launchPermissionModificationsRemoveListValue.group() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)launchPermissionModificationsRemoveListValue.group()));
                    }
                    if (launchPermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)launchPermissionModificationsRemoveListValue.userId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyImageAttributeRequest.operationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifyImageAttributeRequest.operationType()));
        }
        if ((modifyImageAttributeRequestProductCodesList = modifyImageAttributeRequest.productCodes()) != null) {
            int productCodesListIndex = 1;
            for (String string : modifyImageAttributeRequestProductCodesList) {
                if (string != null) {
                    request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString((String)string));
                }
                ++productCodesListIndex;
            }
        }
        if ((modifyImageAttributeRequestUserGroupsList = modifyImageAttributeRequest.userGroups()) != null) {
            int userGroupsListIndex = 1;
            for (String modifyImageAttributeRequestUserGroupsListValue : modifyImageAttributeRequestUserGroupsList) {
                if (modifyImageAttributeRequestUserGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString((String)modifyImageAttributeRequestUserGroupsListValue));
                }
                ++userGroupsListIndex;
            }
        }
        if ((modifyImageAttributeRequestUserIdsList = modifyImageAttributeRequest.userIds()) != null) {
            boolean bl = true;
            for (String modifyImageAttributeRequestUserIdsListValue : modifyImageAttributeRequestUserIdsList) {
                void var7_21;
                if (modifyImageAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + (int)var7_21, StringUtils.fromString((String)modifyImageAttributeRequestUserIdsListValue));
                }
                ++var7_21;
            }
        }
        if (modifyImageAttributeRequest.value() != null) {
            request.addParameter("Value", StringUtils.fromString((String)modifyImageAttributeRequest.value()));
        }
        return request;
    }
}

