/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.InstanceAttribute;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceBlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ProductCodeUnmarshaller;

public class InstanceAttributeUnmarshaller
implements Unmarshaller<InstanceAttribute, StaxUnmarshallerContext> {
    private static final InstanceAttributeUnmarshaller INSTANCE = new InstanceAttributeUnmarshaller();

    public InstanceAttribute unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceAttribute.Builder instanceAttribute;
        block21: {
            instanceAttribute = InstanceAttribute.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<GroupIdentifier> groups = null;
            ArrayList<InstanceBlockDeviceMapping> blockDeviceMappings = null;
            ArrayList<ProductCode> productCodes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    instanceAttribute.groups(groups);
                    instanceAttribute.blockDeviceMappings(blockDeviceMappings);
                    instanceAttribute.productCodes(productCodes);
                    break block21;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("groupSet", targetDepth)) {
                        groups = new ArrayList<GroupIdentifier>();
                        continue;
                    }
                    if (context.testExpression("groupSet/item", targetDepth)) {
                        groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping", targetDepth)) {
                        blockDeviceMappings = new ArrayList<InstanceBlockDeviceMapping>();
                        continue;
                    }
                    if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                        blockDeviceMappings.add(InstanceBlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("disableApiTermination/value", targetDepth)) {
                        instanceAttribute.disableApiTermination(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("enaSupport/value", targetDepth)) {
                        instanceAttribute.enaSupport(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ebsOptimized/value", targetDepth)) {
                        instanceAttribute.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceId", targetDepth)) {
                        instanceAttribute.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceInitiatedShutdownBehavior/value", targetDepth)) {
                        instanceAttribute.instanceInitiatedShutdownBehavior(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceType/value", targetDepth)) {
                        instanceAttribute.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("kernel/value", targetDepth)) {
                        instanceAttribute.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("productCodes", targetDepth)) {
                        productCodes = new ArrayList<ProductCode>();
                        continue;
                    }
                    if (context.testExpression("productCodes/item", targetDepth)) {
                        productCodes.add(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ramdisk/value", targetDepth)) {
                        instanceAttribute.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("rootDeviceName/value", targetDepth)) {
                        instanceAttribute.rootDeviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("sourceDestCheck/value", targetDepth)) {
                        instanceAttribute.sourceDestCheck(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("sriovNetSupport/value", targetDepth)) {
                        instanceAttribute.sriovNetSupport(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("userData/value", targetDepth)) continue;
                    instanceAttribute.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            instanceAttribute.groups(groups);
            instanceAttribute.blockDeviceMappings(blockDeviceMappings);
            instanceAttribute.productCodes(productCodes);
        }
        return (InstanceAttribute)instanceAttribute.build();
    }

    public static InstanceAttributeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

