/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeNatGatewaysRequestMarshaller
implements Marshaller<Request<DescribeNatGatewaysRequest>, DescribeNatGatewaysRequest> {
    public Request<DescribeNatGatewaysRequest> marshall(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        List<String> describeNatGatewaysRequestNatGatewayIdsList;
        if (describeNatGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNatGatewaysRequest, "EC2Client");
        request.addParameter("Action", "DescribeNatGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeNatGatewaysRequestFilterList = describeNatGatewaysRequest.filter();
        if (describeNatGatewaysRequestFilterList != null) {
            int filterListIndex = 1;
            for (Filter describeNatGatewaysRequestFilterListValue : describeNatGatewaysRequestFilterList) {
                List<String> filterValuesList;
                if (describeNatGatewaysRequestFilterListValue.name() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeNatGatewaysRequestFilterListValue.name()));
                }
                if ((filterValuesList = describeNatGatewaysRequestFilterListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeNatGatewaysRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeNatGatewaysRequest.maxResults()));
        }
        if ((describeNatGatewaysRequestNatGatewayIdsList = describeNatGatewaysRequest.natGatewayIds()) != null) {
            int natGatewayIdsListIndex = 1;
            for (String describeNatGatewaysRequestNatGatewayIdsListValue : describeNatGatewaysRequestNatGatewayIdsList) {
                if (describeNatGatewaysRequestNatGatewayIdsListValue != null) {
                    request.addParameter("NatGatewayId." + natGatewayIdsListIndex, StringUtils.fromString((String)describeNatGatewaysRequestNatGatewayIdsListValue));
                }
                ++natGatewayIdsListIndex;
            }
        }
        if (describeNatGatewaysRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeNatGatewaysRequest.nextToken()));
        }
        return request;
    }
}

