/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.IcmpTypeCode;
import software.amazon.awssdk.services.ec2.model.PortRange;
import software.amazon.awssdk.services.ec2.model.RuleAction;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkAclEntry
implements ToCopyableBuilder<Builder, NetworkAclEntry> {
    private final String cidrBlock;
    private final Boolean egress;
    private final IcmpTypeCode icmpTypeCode;
    private final String ipv6CidrBlock;
    private final PortRange portRange;
    private final String protocol;
    private final String ruleAction;
    private final Integer ruleNumber;

    private NetworkAclEntry(BuilderImpl builder) {
        this.cidrBlock = builder.cidrBlock;
        this.egress = builder.egress;
        this.icmpTypeCode = builder.icmpTypeCode;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.portRange = builder.portRange;
        this.protocol = builder.protocol;
        this.ruleAction = builder.ruleAction;
        this.ruleNumber = builder.ruleNumber;
    }

    public String cidrBlock() {
        return this.cidrBlock;
    }

    public Boolean egress() {
        return this.egress;
    }

    public IcmpTypeCode icmpTypeCode() {
        return this.icmpTypeCode;
    }

    public String ipv6CidrBlock() {
        return this.ipv6CidrBlock;
    }

    public PortRange portRange() {
        return this.portRange;
    }

    public String protocol() {
        return this.protocol;
    }

    public String ruleAction() {
        return this.ruleAction;
    }

    public Integer ruleNumber() {
        return this.ruleNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.cidrBlock() == null ? 0 : this.cidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.egress() == null ? 0 : this.egress().hashCode());
        hashCode = 31 * hashCode + (this.icmpTypeCode() == null ? 0 : this.icmpTypeCode().hashCode());
        hashCode = 31 * hashCode + (this.ipv6CidrBlock() == null ? 0 : this.ipv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.portRange() == null ? 0 : this.portRange().hashCode());
        hashCode = 31 * hashCode + (this.protocol() == null ? 0 : this.protocol().hashCode());
        hashCode = 31 * hashCode + (this.ruleAction() == null ? 0 : this.ruleAction().hashCode());
        hashCode = 31 * hashCode + (this.ruleNumber() == null ? 0 : this.ruleNumber().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclEntry)) {
            return false;
        }
        NetworkAclEntry other = (NetworkAclEntry)obj;
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.egress() == null ^ this.egress() == null) {
            return false;
        }
        if (other.egress() != null && !other.egress().equals(this.egress())) {
            return false;
        }
        if (other.icmpTypeCode() == null ^ this.icmpTypeCode() == null) {
            return false;
        }
        if (other.icmpTypeCode() != null && !other.icmpTypeCode().equals(this.icmpTypeCode())) {
            return false;
        }
        if (other.ipv6CidrBlock() == null ^ this.ipv6CidrBlock() == null) {
            return false;
        }
        if (other.ipv6CidrBlock() != null && !other.ipv6CidrBlock().equals(this.ipv6CidrBlock())) {
            return false;
        }
        if (other.portRange() == null ^ this.portRange() == null) {
            return false;
        }
        if (other.portRange() != null && !other.portRange().equals(this.portRange())) {
            return false;
        }
        if (other.protocol() == null ^ this.protocol() == null) {
            return false;
        }
        if (other.protocol() != null && !other.protocol().equals(this.protocol())) {
            return false;
        }
        if (other.ruleAction() == null ^ this.ruleAction() == null) {
            return false;
        }
        if (other.ruleAction() != null && !other.ruleAction().equals(this.ruleAction())) {
            return false;
        }
        if (other.ruleNumber() == null ^ this.ruleNumber() == null) {
            return false;
        }
        return other.ruleNumber() == null || other.ruleNumber().equals(this.ruleNumber());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.cidrBlock()).append(",");
        }
        if (this.egress() != null) {
            sb.append("Egress: ").append(this.egress()).append(",");
        }
        if (this.icmpTypeCode() != null) {
            sb.append("IcmpTypeCode: ").append(this.icmpTypeCode()).append(",");
        }
        if (this.ipv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(this.ipv6CidrBlock()).append(",");
        }
        if (this.portRange() != null) {
            sb.append("PortRange: ").append(this.portRange()).append(",");
        }
        if (this.protocol() != null) {
            sb.append("Protocol: ").append(this.protocol()).append(",");
        }
        if (this.ruleAction() != null) {
            sb.append("RuleAction: ").append(this.ruleAction()).append(",");
        }
        if (this.ruleNumber() != null) {
            sb.append("RuleNumber: ").append(this.ruleNumber()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String cidrBlock;
        private Boolean egress;
        private IcmpTypeCode icmpTypeCode;
        private String ipv6CidrBlock;
        private PortRange portRange;
        private String protocol;
        private String ruleAction;
        private Integer ruleNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclEntry model) {
            this.setCidrBlock(model.cidrBlock);
            this.setEgress(model.egress);
            this.setIcmpTypeCode(model.icmpTypeCode);
            this.setIpv6CidrBlock(model.ipv6CidrBlock);
            this.setPortRange(model.portRange);
            this.setProtocol(model.protocol);
            this.setRuleAction(model.ruleAction);
            this.setRuleNumber(model.ruleNumber);
        }

        public final String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final Boolean getEgress() {
            return this.egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        public final IcmpTypeCode getIcmpTypeCode() {
            return this.icmpTypeCode;
        }

        @Override
        public final Builder icmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
            return this;
        }

        public final void setIcmpTypeCode(IcmpTypeCode icmpTypeCode) {
            this.icmpTypeCode = icmpTypeCode;
        }

        public final String getIpv6CidrBlock() {
            return this.ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final PortRange getPortRange() {
            return this.portRange;
        }

        @Override
        public final Builder portRange(PortRange portRange) {
            this.portRange = portRange;
            return this;
        }

        public final void setPortRange(PortRange portRange) {
            this.portRange = portRange;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public final String getRuleAction() {
            return this.ruleAction;
        }

        @Override
        public final Builder ruleAction(String ruleAction) {
            this.ruleAction = ruleAction;
            return this;
        }

        @Override
        public final Builder ruleAction(RuleAction ruleAction) {
            this.ruleAction(ruleAction.toString());
            return this;
        }

        public final void setRuleAction(String ruleAction) {
            this.ruleAction = ruleAction;
        }

        public final Integer getRuleNumber() {
            return this.ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        public NetworkAclEntry build() {
            return new NetworkAclEntry(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkAclEntry> {
        public Builder cidrBlock(String var1);

        public Builder egress(Boolean var1);

        public Builder icmpTypeCode(IcmpTypeCode var1);

        public Builder ipv6CidrBlock(String var1);

        public Builder portRange(PortRange var1);

        public Builder protocol(String var1);

        public Builder ruleAction(String var1);

        public Builder ruleAction(RuleAction var1);

        public Builder ruleNumber(Integer var1);
    }
}

