/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.ExportTaskState;
import software.amazon.awssdk.services.ec2.model.ExportToS3Task;
import software.amazon.awssdk.services.ec2.model.InstanceExportDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ExportTask
implements ToCopyableBuilder<Builder, ExportTask> {
    private final String description;
    private final String exportTaskId;
    private final ExportToS3Task exportToS3Task;
    private final InstanceExportDetails instanceExportDetails;
    private final String state;
    private final String statusMessage;

    private ExportTask(BuilderImpl builder) {
        this.description = builder.description;
        this.exportTaskId = builder.exportTaskId;
        this.exportToS3Task = builder.exportToS3Task;
        this.instanceExportDetails = builder.instanceExportDetails;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    public String description() {
        return this.description;
    }

    public String exportTaskId() {
        return this.exportTaskId;
    }

    public ExportToS3Task exportToS3Task() {
        return this.exportToS3Task;
    }

    public InstanceExportDetails instanceExportDetails() {
        return this.instanceExportDetails;
    }

    public String state() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.exportTaskId() == null ? 0 : this.exportTaskId().hashCode());
        hashCode = 31 * hashCode + (this.exportToS3Task() == null ? 0 : this.exportToS3Task().hashCode());
        hashCode = 31 * hashCode + (this.instanceExportDetails() == null ? 0 : this.instanceExportDetails().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.statusMessage() == null ? 0 : this.statusMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask)obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.exportTaskId() == null ^ this.exportTaskId() == null) {
            return false;
        }
        if (other.exportTaskId() != null && !other.exportTaskId().equals(this.exportTaskId())) {
            return false;
        }
        if (other.exportToS3Task() == null ^ this.exportToS3Task() == null) {
            return false;
        }
        if (other.exportToS3Task() != null && !other.exportToS3Task().equals(this.exportToS3Task())) {
            return false;
        }
        if (other.instanceExportDetails() == null ^ this.instanceExportDetails() == null) {
            return false;
        }
        if (other.instanceExportDetails() != null && !other.instanceExportDetails().equals(this.instanceExportDetails())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.statusMessage() == null ^ this.statusMessage() == null) {
            return false;
        }
        return other.statusMessage() == null || other.statusMessage().equals(this.statusMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.exportTaskId() != null) {
            sb.append("ExportTaskId: ").append(this.exportTaskId()).append(",");
        }
        if (this.exportToS3Task() != null) {
            sb.append("ExportToS3Task: ").append(this.exportToS3Task()).append(",");
        }
        if (this.instanceExportDetails() != null) {
            sb.append("InstanceExportDetails: ").append(this.instanceExportDetails()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.statusMessage() != null) {
            sb.append("StatusMessage: ").append(this.statusMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String description;
        private String exportTaskId;
        private ExportToS3Task exportToS3Task;
        private InstanceExportDetails instanceExportDetails;
        private String state;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            this.setDescription(model.description);
            this.setExportTaskId(model.exportTaskId);
            this.setExportToS3Task(model.exportToS3Task);
            this.setInstanceExportDetails(model.instanceExportDetails);
            this.setState(model.state);
            this.setStatusMessage(model.statusMessage);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getExportTaskId() {
            return this.exportTaskId;
        }

        @Override
        public final Builder exportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
            return this;
        }

        public final void setExportTaskId(String exportTaskId) {
            this.exportTaskId = exportTaskId;
        }

        public final ExportToS3Task getExportToS3Task() {
            return this.exportToS3Task;
        }

        @Override
        public final Builder exportToS3Task(ExportToS3Task exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        public final void setExportToS3Task(ExportToS3Task exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
        }

        public final InstanceExportDetails getInstanceExportDetails() {
            return this.instanceExportDetails;
        }

        @Override
        public final Builder instanceExportDetails(InstanceExportDetails instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails;
            return this;
        }

        public final void setInstanceExportDetails(InstanceExportDetails instanceExportDetails) {
            this.instanceExportDetails = instanceExportDetails;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ExportTaskState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public ExportTask build() {
            return new ExportTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ExportTask> {
        public Builder description(String var1);

        public Builder exportTaskId(String var1);

        public Builder exportToS3Task(ExportToS3Task var1);

        public Builder instanceExportDetails(InstanceExportDetails var1);

        public Builder state(String var1);

        public Builder state(ExportTaskState var1);

        public Builder statusMessage(String var1);
    }
}

