/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ExportTask;
import software.amazon.awssdk.services.ec2.model.ExportTaskListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExportTasksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeExportTasksResponse> {
    private final List<ExportTask> exportTasks;

    private DescribeExportTasksResponse(BuilderImpl builder) {
        this.exportTasks = builder.exportTasks;
    }

    public List<ExportTask> exportTasks() {
        return this.exportTasks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.exportTasks() == null ? 0 : this.exportTasks().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksResponse)) {
            return false;
        }
        DescribeExportTasksResponse other = (DescribeExportTasksResponse)((Object)obj);
        if (other.exportTasks() == null ^ this.exportTasks() == null) {
            return false;
        }
        return other.exportTasks() == null || other.exportTasks().equals(this.exportTasks());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exportTasks() != null) {
            sb.append("ExportTasks: ").append(this.exportTasks()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ExportTask> exportTasks;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksResponse model) {
            this.setExportTasks(model.exportTasks);
        }

        public final Collection<ExportTask> getExportTasks() {
            return this.exportTasks;
        }

        @Override
        public final Builder exportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTaskListCopier.copy(exportTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTasks(ExportTask ... exportTasks) {
            this.exportTasks(Arrays.asList(exportTasks));
            return this;
        }

        public final void setExportTasks(Collection<ExportTask> exportTasks) {
            this.exportTasks = ExportTaskListCopier.copy(exportTasks);
        }

        public DescribeExportTasksResponse build() {
            return new DescribeExportTasksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeExportTasksResponse> {
        public Builder exportTasks(Collection<ExportTask> var1);

        public Builder exportTasks(ExportTask ... var1);
    }
}

