/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.util;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.SimpleTimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import software.amazon.awssdk.util.StringUtils;
import software.amazon.awssdk.utils.Base64Utils;

public class S3UploadPolicy {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";
    private String policySignature;
    private String policyString;

    public S3UploadPolicy(String awsAccessKeyId, String awsSecretKey, String bucketName, String prefix, int expireInMinutes) {
        Calendar expirationDate = Calendar.getInstance();
        expirationDate.add(12, expireInMinutes);
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        iso8601.setTimeZone(new SimpleTimeZone(0, "GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{").append("\"expiration\": \"").append(iso8601.format(expirationDate.getTime())).append("\",").append("\"conditions\": [").append("{\"bucket\": \"").append(bucketName).append("\"},").append("{\"acl\": \"").append("ec2-bundle-read").append("\"},").append("[\"starts-with\", \"$key\", \"").append(prefix).append("\"]").append("]}");
        try {
            this.policyString = this.base64Encode(builder.toString().getBytes(StringUtils.UTF8));
            this.policySignature = this.signPolicy(awsSecretKey, this.policyString);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to generate S3 upload policy", ex);
        }
    }

    public String getPolicyString() {
        return this.policyString;
    }

    public String getPolicySignature() {
        return this.policySignature;
    }

    private String signPolicy(String awsSecretKey, String base64EncodedPolicy) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        SecretKeySpec signingKey = new SecretKeySpec(awsSecretKey.getBytes(), HMAC_SHA1_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
        mac.init(signingKey);
        return this.base64Encode(mac.doFinal(base64EncodedPolicy.getBytes()));
    }

    private String base64Encode(byte[] data) {
        return Base64Utils.encodeAsString((byte[])data).replaceAll("\\s", "");
    }
}

