/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ReservationValue;

public class ReservationValueUnmarshaller
implements Unmarshaller<ReservationValue, StaxUnmarshallerContext> {
    private static ReservationValueUnmarshaller INSTANCE;

    public ReservationValue unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReservationValue.Builder reservationValue = ReservationValue.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("hourlyPrice", targetDepth)) {
                    reservationValue.hourlyPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("remainingTotalValue", targetDepth)) {
                    reservationValue.remainingTotalValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("remainingUpfrontValue", targetDepth)) continue;
                reservationValue.remainingUpfrontValue(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReservationValue)reservationValue.build();
    }

    public static ReservationValueUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReservationValueUnmarshaller();
        }
        return INSTANCE;
    }
}

