/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ProductCode;

public class ProductCodeUnmarshaller
implements Unmarshaller<ProductCode, StaxUnmarshallerContext> {
    private static ProductCodeUnmarshaller INSTANCE;

    public ProductCode unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ProductCode.Builder productCode = ProductCode.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("productCode", targetDepth)) {
                    productCode.productCodeId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("type", targetDepth)) continue;
                productCode.productCodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ProductCode)productCode.build();
    }

    public static ProductCodeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProductCodeUnmarshaller();
        }
        return INSTANCE;
    }
}

