/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InstanceStatus;
import software.amazon.awssdk.services.ec2.model.InstanceStatusEvent;
import software.amazon.awssdk.services.ec2.transform.InstanceStateUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceStatusEventUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceStatusSummaryUnmarshaller;

public class InstanceStatusUnmarshaller
implements Unmarshaller<InstanceStatus, StaxUnmarshallerContext> {
    private static InstanceStatusUnmarshaller INSTANCE;

    public InstanceStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        InstanceStatus.Builder instanceStatus;
        block10: {
            instanceStatus = InstanceStatus.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<InstanceStatusEvent> events = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    instanceStatus.events(events);
                    break block10;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("availabilityZone", targetDepth)) {
                        instanceStatus.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("eventsSet", targetDepth)) {
                        events = new ArrayList<InstanceStatusEvent>();
                        continue;
                    }
                    if (context.testExpression("eventsSet/item", targetDepth)) {
                        events.add(InstanceStatusEventUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceId", targetDepth)) {
                        instanceStatus.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceState", targetDepth)) {
                        instanceStatus.instanceState(InstanceStateUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceStatus", targetDepth)) {
                        instanceStatus.instanceStatus(InstanceStatusSummaryUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("systemStatus", targetDepth)) continue;
                    instanceStatus.systemStatus(InstanceStatusSummaryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            instanceStatus.events(events);
        }
        return (InstanceStatus)instanceStatus.build();
    }

    public static InstanceStatusUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstanceStatusUnmarshaller();
        }
        return INSTANCE;
    }
}

