/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.HostReservation;

public class HostReservationUnmarshaller
implements Unmarshaller<HostReservation, StaxUnmarshallerContext> {
    private static HostReservationUnmarshaller INSTANCE;

    public HostReservation unmarshall(StaxUnmarshallerContext context) throws Exception {
        HostReservation.Builder hostReservation;
        block17: {
            hostReservation = HostReservation.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> hostIdSet = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    hostReservation.hostIdSet(hostIdSet);
                    break block17;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("count", targetDepth)) {
                        hostReservation.count(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("currencyCode", targetDepth)) {
                        hostReservation.currencyCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("duration", targetDepth)) {
                        hostReservation.duration(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("end", targetDepth)) {
                        hostReservation.end(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("hostIdSet", targetDepth)) {
                        hostIdSet = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("hostIdSet/item", targetDepth)) {
                        hostIdSet.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("hostReservationId", targetDepth)) {
                        hostReservation.hostReservationId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("hourlyPrice", targetDepth)) {
                        hostReservation.hourlyPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceFamily", targetDepth)) {
                        hostReservation.instanceFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("offeringId", targetDepth)) {
                        hostReservation.offeringId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("paymentOption", targetDepth)) {
                        hostReservation.paymentOption(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("start", targetDepth)) {
                        hostReservation.start(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        hostReservation.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("upfrontPrice", targetDepth)) continue;
                    hostReservation.upfrontPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            hostReservation.hostIdSet(hostIdSet);
        }
        return (HostReservation)hostReservation.build();
    }

    public static HostReservationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HostReservationUnmarshaller();
        }
        return INSTANCE;
    }
}

