/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceRecurrenceRequest;
import software.amazon.awssdk.services.ec2.model.SlotDateTimeRangeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeScheduledInstanceAvailabilityRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstanceAvailabilityRequest>, DescribeScheduledInstanceAvailabilityRequest> {
    public Request<DescribeScheduledInstanceAvailabilityRequest> marshall(DescribeScheduledInstanceAvailabilityRequest describeScheduledInstanceAvailabilityRequest) {
        ScheduledInstanceRecurrenceRequest recurrence;
        SlotDateTimeRangeRequest firstSlotStartTimeRange;
        if (describeScheduledInstanceAvailabilityRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScheduledInstanceAvailabilityRequest, "EC2Client");
        request.addParameter("Action", "DescribeScheduledInstanceAvailability");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeScheduledInstanceAvailabilityRequestFiltersList = describeScheduledInstanceAvailabilityRequest.filters();
        if (describeScheduledInstanceAvailabilityRequestFiltersList != null) {
            int filtersListIndex = 1;
            for (Filter describeScheduledInstanceAvailabilityRequestFiltersListValue : describeScheduledInstanceAvailabilityRequestFiltersList) {
                List<String> filterValuesList;
                if (describeScheduledInstanceAvailabilityRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeScheduledInstanceAvailabilityRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeScheduledInstanceAvailabilityRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if ((firstSlotStartTimeRange = describeScheduledInstanceAvailabilityRequest.firstSlotStartTimeRange()) != null) {
            if (firstSlotStartTimeRange.earliestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.EarliestTime", StringUtils.fromInstant((Instant)firstSlotStartTimeRange.earliestTime()));
            }
            if (firstSlotStartTimeRange.latestTime() != null) {
                request.addParameter("FirstSlotStartTimeRange.LatestTime", StringUtils.fromInstant((Instant)firstSlotStartTimeRange.latestTime()));
            }
        }
        if (describeScheduledInstanceAvailabilityRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeScheduledInstanceAvailabilityRequest.maxResults()));
        }
        if (describeScheduledInstanceAvailabilityRequest.maxSlotDurationInHours() != null) {
            request.addParameter("MaxSlotDurationInHours", StringUtils.fromInteger((Integer)describeScheduledInstanceAvailabilityRequest.maxSlotDurationInHours()));
        }
        if (describeScheduledInstanceAvailabilityRequest.minSlotDurationInHours() != null) {
            request.addParameter("MinSlotDurationInHours", StringUtils.fromInteger((Integer)describeScheduledInstanceAvailabilityRequest.minSlotDurationInHours()));
        }
        if (describeScheduledInstanceAvailabilityRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeScheduledInstanceAvailabilityRequest.nextToken()));
        }
        if ((recurrence = describeScheduledInstanceAvailabilityRequest.recurrence()) != null) {
            List<Integer> scheduledInstanceRecurrenceRequestOccurrenceDaysList;
            if (recurrence.frequency() != null) {
                request.addParameter("Recurrence.Frequency", StringUtils.fromString((String)recurrence.frequency()));
            }
            if (recurrence.interval() != null) {
                request.addParameter("Recurrence.Interval", StringUtils.fromInteger((Integer)recurrence.interval()));
            }
            if ((scheduledInstanceRecurrenceRequestOccurrenceDaysList = recurrence.occurrenceDays()) != null) {
                int occurrenceDaysListIndex = 1;
                for (Integer scheduledInstanceRecurrenceRequestOccurrenceDaysListValue : scheduledInstanceRecurrenceRequestOccurrenceDaysList) {
                    if (scheduledInstanceRecurrenceRequestOccurrenceDaysListValue != null) {
                        request.addParameter("Recurrence.OccurrenceDay." + occurrenceDaysListIndex, StringUtils.fromInteger((Integer)scheduledInstanceRecurrenceRequestOccurrenceDaysListValue));
                    }
                    ++occurrenceDaysListIndex;
                }
            }
            if (recurrence.occurrenceRelativeToEnd() != null) {
                request.addParameter("Recurrence.OccurrenceRelativeToEnd", StringUtils.fromBoolean((Boolean)recurrence.occurrenceRelativeToEnd()));
            }
            if (recurrence.occurrenceUnit() != null) {
                request.addParameter("Recurrence.OccurrenceUnit", StringUtils.fromString((String)recurrence.occurrenceUnit()));
            }
        }
        return request;
    }
}

