/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeBundleTasksRequestMarshaller
implements Marshaller<Request<DescribeBundleTasksRequest>, DescribeBundleTasksRequest> {
    public Request<DescribeBundleTasksRequest> marshall(DescribeBundleTasksRequest describeBundleTasksRequest) {
        List<Filter> describeBundleTasksRequestFiltersList;
        if (describeBundleTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeBundleTasksRequest, "EC2Client");
        request.addParameter("Action", "DescribeBundleTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeBundleTasksRequestBundleIdsList = describeBundleTasksRequest.bundleIds();
        if (describeBundleTasksRequestBundleIdsList != null) {
            int bundleIdsListIndex = 1;
            for (String describeBundleTasksRequestBundleIdsListValue : describeBundleTasksRequestBundleIdsList) {
                if (describeBundleTasksRequestBundleIdsListValue != null) {
                    request.addParameter("BundleId." + bundleIdsListIndex, StringUtils.fromString((String)describeBundleTasksRequestBundleIdsListValue));
                }
                ++bundleIdsListIndex;
            }
        }
        if ((describeBundleTasksRequestFiltersList = describeBundleTasksRequest.filters()) != null) {
            int filtersListIndex = 1;
            for (Filter describeBundleTasksRequestFiltersListValue : describeBundleTasksRequestFiltersList) {
                List<String> filterValuesList;
                if (describeBundleTasksRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeBundleTasksRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeBundleTasksRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

