/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.GatewayType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VgwTelemetry;
import software.amazon.awssdk.services.ec2.model.VgwTelemetryListCopier;
import software.amazon.awssdk.services.ec2.model.VpnConnectionOptions;
import software.amazon.awssdk.services.ec2.model.VpnState;
import software.amazon.awssdk.services.ec2.model.VpnStaticRoute;
import software.amazon.awssdk.services.ec2.model.VpnStaticRouteListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VpnConnection
implements ToCopyableBuilder<Builder, VpnConnection> {
    private final String customerGatewayConfiguration;
    private final String customerGatewayId;
    private final String state;
    private final String type;
    private final String vpnConnectionId;
    private final String vpnGatewayId;
    private final VpnConnectionOptions options;
    private final List<VpnStaticRoute> routes;
    private final List<Tag> tags;
    private final List<VgwTelemetry> vgwTelemetry;

    private VpnConnection(BuilderImpl builder) {
        this.customerGatewayConfiguration = builder.customerGatewayConfiguration;
        this.customerGatewayId = builder.customerGatewayId;
        this.state = builder.state;
        this.type = builder.type;
        this.vpnConnectionId = builder.vpnConnectionId;
        this.vpnGatewayId = builder.vpnGatewayId;
        this.options = builder.options;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vgwTelemetry = builder.vgwTelemetry;
    }

    public String customerGatewayConfiguration() {
        return this.customerGatewayConfiguration;
    }

    public String customerGatewayId() {
        return this.customerGatewayId;
    }

    public String state() {
        return this.state;
    }

    public String type() {
        return this.type;
    }

    public String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    public String vpnGatewayId() {
        return this.vpnGatewayId;
    }

    public VpnConnectionOptions options() {
        return this.options;
    }

    public List<VpnStaticRoute> routes() {
        return this.routes;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public List<VgwTelemetry> vgwTelemetry() {
        return this.vgwTelemetry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.customerGatewayConfiguration() == null ? 0 : this.customerGatewayConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.customerGatewayId() == null ? 0 : this.customerGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.vpnConnectionId() == null ? 0 : this.vpnConnectionId().hashCode());
        hashCode = 31 * hashCode + (this.vpnGatewayId() == null ? 0 : this.vpnGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        hashCode = 31 * hashCode + (this.routes() == null ? 0 : this.routes().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.vgwTelemetry() == null ? 0 : this.vgwTelemetry().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpnConnection)) {
            return false;
        }
        VpnConnection other = (VpnConnection)obj;
        if (other.customerGatewayConfiguration() == null ^ this.customerGatewayConfiguration() == null) {
            return false;
        }
        if (other.customerGatewayConfiguration() != null && !other.customerGatewayConfiguration().equals(this.customerGatewayConfiguration())) {
            return false;
        }
        if (other.customerGatewayId() == null ^ this.customerGatewayId() == null) {
            return false;
        }
        if (other.customerGatewayId() != null && !other.customerGatewayId().equals(this.customerGatewayId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.vpnConnectionId() == null ^ this.vpnConnectionId() == null) {
            return false;
        }
        if (other.vpnConnectionId() != null && !other.vpnConnectionId().equals(this.vpnConnectionId())) {
            return false;
        }
        if (other.vpnGatewayId() == null ^ this.vpnGatewayId() == null) {
            return false;
        }
        if (other.vpnGatewayId() != null && !other.vpnGatewayId().equals(this.vpnGatewayId())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        if (other.routes() == null ^ this.routes() == null) {
            return false;
        }
        if (other.routes() != null && !other.routes().equals(this.routes())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vgwTelemetry() == null ^ this.vgwTelemetry() == null) {
            return false;
        }
        return other.vgwTelemetry() == null || other.vgwTelemetry().equals(this.vgwTelemetry());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.customerGatewayConfiguration() != null) {
            sb.append("CustomerGatewayConfiguration: ").append(this.customerGatewayConfiguration()).append(",");
        }
        if (this.customerGatewayId() != null) {
            sb.append("CustomerGatewayId: ").append(this.customerGatewayId()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.vpnConnectionId() != null) {
            sb.append("VpnConnectionId: ").append(this.vpnConnectionId()).append(",");
        }
        if (this.vpnGatewayId() != null) {
            sb.append("VpnGatewayId: ").append(this.vpnGatewayId()).append(",");
        }
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (this.routes() != null) {
            sb.append("Routes: ").append(this.routes()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vgwTelemetry() != null) {
            sb.append("VgwTelemetry: ").append(this.vgwTelemetry()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String customerGatewayConfiguration;
        private String customerGatewayId;
        private String state;
        private String type;
        private String vpnConnectionId;
        private String vpnGatewayId;
        private VpnConnectionOptions options;
        private List<VpnStaticRoute> routes;
        private List<Tag> tags;
        private List<VgwTelemetry> vgwTelemetry;

        private BuilderImpl() {
        }

        private BuilderImpl(VpnConnection model) {
            this.setCustomerGatewayConfiguration(model.customerGatewayConfiguration);
            this.setCustomerGatewayId(model.customerGatewayId);
            this.setState(model.state);
            this.setType(model.type);
            this.setVpnConnectionId(model.vpnConnectionId);
            this.setVpnGatewayId(model.vpnGatewayId);
            this.setOptions(model.options);
            this.setRoutes(model.routes);
            this.setTags(model.tags);
            this.setVgwTelemetry(model.vgwTelemetry);
        }

        public final String getCustomerGatewayConfiguration() {
            return this.customerGatewayConfiguration;
        }

        @Override
        public final Builder customerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
            return this;
        }

        public final void setCustomerGatewayConfiguration(String customerGatewayConfiguration) {
            this.customerGatewayConfiguration = customerGatewayConfiguration;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VpnState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(VpnState state) {
            this.state(state.toString());
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(GatewayType type) {
            this.type(type.toString());
        }

        public final String getVpnConnectionId() {
            return this.vpnConnectionId;
        }

        @Override
        public final Builder vpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
            return this;
        }

        public final void setVpnConnectionId(String vpnConnectionId) {
            this.vpnConnectionId = vpnConnectionId;
        }

        public final String getVpnGatewayId() {
            return this.vpnGatewayId;
        }

        @Override
        public final Builder vpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
            return this;
        }

        public final void setVpnGatewayId(String vpnGatewayId) {
            this.vpnGatewayId = vpnGatewayId;
        }

        public final VpnConnectionOptions getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(VpnConnectionOptions options) {
            this.options = options;
            return this;
        }

        public final void setOptions(VpnConnectionOptions options) {
            this.options = options;
        }

        public final Collection<VpnStaticRoute> getRoutes() {
            return this.routes;
        }

        @Override
        public final Builder routes(Collection<VpnStaticRoute> routes) {
            this.routes = VpnStaticRouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(VpnStaticRoute ... routes) {
            this.routes(Arrays.asList(routes));
            return this;
        }

        public final void setRoutes(Collection<VpnStaticRoute> routes) {
            this.routes = VpnStaticRouteListCopier.copy(routes);
        }

        @SafeVarargs
        public final void setRoutes(VpnStaticRoute ... routes) {
            this.routes(Arrays.asList(routes));
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public final Collection<VgwTelemetry> getVgwTelemetry() {
            return this.vgwTelemetry;
        }

        @Override
        public final Builder vgwTelemetry(Collection<VgwTelemetry> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copy(vgwTelemetry);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vgwTelemetry(VgwTelemetry ... vgwTelemetry) {
            this.vgwTelemetry(Arrays.asList(vgwTelemetry));
            return this;
        }

        public final void setVgwTelemetry(Collection<VgwTelemetry> vgwTelemetry) {
            this.vgwTelemetry = VgwTelemetryListCopier.copy(vgwTelemetry);
        }

        @SafeVarargs
        public final void setVgwTelemetry(VgwTelemetry ... vgwTelemetry) {
            this.vgwTelemetry(Arrays.asList(vgwTelemetry));
        }

        public VpnConnection build() {
            return new VpnConnection(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VpnConnection> {
        public Builder customerGatewayConfiguration(String var1);

        public Builder customerGatewayId(String var1);

        public Builder state(String var1);

        public Builder state(VpnState var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);

        public Builder vpnConnectionId(String var1);

        public Builder vpnGatewayId(String var1);

        public Builder options(VpnConnectionOptions var1);

        public Builder routes(Collection<VpnStaticRoute> var1);

        public Builder routes(VpnStaticRoute ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vgwTelemetry(Collection<VgwTelemetry> var1);

        public Builder vgwTelemetry(VgwTelemetry ... var1);
    }
}

