/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.InstanceIdSetCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RunScheduledInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, RunScheduledInstancesResponse> {
    private final List<String> instanceIdSet;

    private RunScheduledInstancesResponse(BuilderImpl builder) {
        this.instanceIdSet = builder.instanceIdSet;
    }

    public List<String> instanceIdSet() {
        return this.instanceIdSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceIdSet() == null ? 0 : this.instanceIdSet().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunScheduledInstancesResponse)) {
            return false;
        }
        RunScheduledInstancesResponse other = (RunScheduledInstancesResponse)((Object)obj);
        if (other.instanceIdSet() == null ^ this.instanceIdSet() == null) {
            return false;
        }
        return other.instanceIdSet() == null || other.instanceIdSet().equals(this.instanceIdSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceIdSet() != null) {
            sb.append("InstanceIdSet: ").append(this.instanceIdSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> instanceIdSet;

        private BuilderImpl() {
        }

        private BuilderImpl(RunScheduledInstancesResponse model) {
            this.setInstanceIdSet(model.instanceIdSet);
        }

        public final Collection<String> getInstanceIdSet() {
            return this.instanceIdSet;
        }

        @Override
        public final Builder instanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIdSet(String ... instanceIdSet) {
            this.instanceIdSet(Arrays.asList(instanceIdSet));
            return this;
        }

        public final void setInstanceIdSet(Collection<String> instanceIdSet) {
            this.instanceIdSet = InstanceIdSetCopier.copy(instanceIdSet);
        }

        @SafeVarargs
        public final void setInstanceIdSet(String ... instanceIdSet) {
            this.instanceIdSet(Arrays.asList(instanceIdSet));
        }

        public RunScheduledInstancesResponse build() {
            return new RunScheduledInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RunScheduledInstancesResponse> {
        public Builder instanceIdSet(Collection<String> var1);

        public Builder instanceIdSet(String ... var1);
    }
}

