/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.InstanceAttributeName;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetInstanceAttributeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ResetInstanceAttributeRequest> {
    private final String attribute;
    private final String instanceId;

    private ResetInstanceAttributeRequest(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.instanceId = builder.instanceId;
    }

    public String attribute() {
        return this.attribute;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attribute() == null ? 0 : this.attribute().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetInstanceAttributeRequest)) {
            return false;
        }
        ResetInstanceAttributeRequest other = (ResetInstanceAttributeRequest)((Object)obj);
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        return other.instanceId() == null || other.instanceId().equals(this.instanceId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attribute() != null) {
            sb.append("Attribute: ").append(this.attribute()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetInstanceAttributeRequest model) {
            this.setAttribute(model.attribute);
            this.setInstanceId(model.instanceId);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final void setAttribute(InstanceAttributeName attribute) {
            this.attribute(attribute.toString());
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public ResetInstanceAttributeRequest build() {
            return new ResetInstanceAttributeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResetInstanceAttributeRequest> {
        public Builder attribute(String var1);

        public Builder attribute(InstanceAttributeName var1);

        public Builder instanceId(String var1);
    }
}

