/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import software.amazon.awssdk.services.ec2.model.AttachmentStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInterfaceAttachment
implements ToCopyableBuilder<Builder, NetworkInterfaceAttachment> {
    private final Instant attachTime;
    private final String attachmentId;
    private final Boolean deleteOnTermination;
    private final Integer deviceIndex;
    private final String instanceId;
    private final String instanceOwnerId;
    private final String status;

    private NetworkInterfaceAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.attachmentId = builder.attachmentId;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.deviceIndex = builder.deviceIndex;
        this.instanceId = builder.instanceId;
        this.instanceOwnerId = builder.instanceOwnerId;
        this.status = builder.status;
    }

    public Instant attachTime() {
        return this.attachTime;
    }

    public String attachmentId() {
        return this.attachmentId;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Integer deviceIndex() {
        return this.deviceIndex;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String instanceOwnerId() {
        return this.instanceOwnerId;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attachTime() == null ? 0 : this.attachTime().hashCode());
        hashCode = 31 * hashCode + (this.attachmentId() == null ? 0 : this.attachmentId().hashCode());
        hashCode = 31 * hashCode + (this.deleteOnTermination() == null ? 0 : this.deleteOnTermination().hashCode());
        hashCode = 31 * hashCode + (this.deviceIndex() == null ? 0 : this.deviceIndex().hashCode());
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.instanceOwnerId() == null ? 0 : this.instanceOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfaceAttachment)) {
            return false;
        }
        NetworkInterfaceAttachment other = (NetworkInterfaceAttachment)obj;
        if (other.attachTime() == null ^ this.attachTime() == null) {
            return false;
        }
        if (other.attachTime() != null && !other.attachTime().equals(this.attachTime())) {
            return false;
        }
        if (other.attachmentId() == null ^ this.attachmentId() == null) {
            return false;
        }
        if (other.attachmentId() != null && !other.attachmentId().equals(this.attachmentId())) {
            return false;
        }
        if (other.deleteOnTermination() == null ^ this.deleteOnTermination() == null) {
            return false;
        }
        if (other.deleteOnTermination() != null && !other.deleteOnTermination().equals(this.deleteOnTermination())) {
            return false;
        }
        if (other.deviceIndex() == null ^ this.deviceIndex() == null) {
            return false;
        }
        if (other.deviceIndex() != null && !other.deviceIndex().equals(this.deviceIndex())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceOwnerId() == null ^ this.instanceOwnerId() == null) {
            return false;
        }
        if (other.instanceOwnerId() != null && !other.instanceOwnerId().equals(this.instanceOwnerId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachTime() != null) {
            sb.append("AttachTime: ").append(this.attachTime()).append(",");
        }
        if (this.attachmentId() != null) {
            sb.append("AttachmentId: ").append(this.attachmentId()).append(",");
        }
        if (this.deleteOnTermination() != null) {
            sb.append("DeleteOnTermination: ").append(this.deleteOnTermination()).append(",");
        }
        if (this.deviceIndex() != null) {
            sb.append("DeviceIndex: ").append(this.deviceIndex()).append(",");
        }
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.instanceOwnerId() != null) {
            sb.append("InstanceOwnerId: ").append(this.instanceOwnerId()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Instant attachTime;
        private String attachmentId;
        private Boolean deleteOnTermination;
        private Integer deviceIndex;
        private String instanceId;
        private String instanceOwnerId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfaceAttachment model) {
            this.setAttachTime(model.attachTime);
            this.setAttachmentId(model.attachmentId);
            this.setDeleteOnTermination(model.deleteOnTermination);
            this.setDeviceIndex(model.deviceIndex);
            this.setInstanceId(model.instanceId);
            this.setInstanceOwnerId(model.instanceOwnerId);
            this.setStatus(model.status);
        }

        public final Instant getAttachTime() {
            return this.attachTime;
        }

        @Override
        public final Builder attachTime(Instant attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final void setAttachTime(Instant attachTime) {
            this.attachTime = attachTime;
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceOwnerId() {
            return this.instanceOwnerId;
        }

        @Override
        public final Builder instanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
            return this;
        }

        public final void setInstanceOwnerId(String instanceOwnerId) {
            this.instanceOwnerId = instanceOwnerId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AttachmentStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(AttachmentStatus status) {
            this.status(status.toString());
        }

        public NetworkInterfaceAttachment build() {
            return new NetworkInterfaceAttachment(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterfaceAttachment> {
        public Builder attachTime(Instant var1);

        public Builder attachmentId(String var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder deviceIndex(Integer var1);

        public Builder instanceId(String var1);

        public Builder instanceOwnerId(String var1);

        public Builder status(String var1);

        public Builder status(AttachmentStatus var1);
    }
}

