/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.DiskImageFormat;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DiskImageDetail
implements ToCopyableBuilder<Builder, DiskImageDetail> {
    private final Long bytes;
    private final String format;
    private final String importManifestUrl;

    private DiskImageDetail(BuilderImpl builder) {
        this.bytes = builder.bytes;
        this.format = builder.format;
        this.importManifestUrl = builder.importManifestUrl;
    }

    public Long bytes() {
        return this.bytes;
    }

    public String format() {
        return this.format;
    }

    public String importManifestUrl() {
        return this.importManifestUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bytes() == null ? 0 : this.bytes().hashCode());
        hashCode = 31 * hashCode + (this.format() == null ? 0 : this.format().hashCode());
        hashCode = 31 * hashCode + (this.importManifestUrl() == null ? 0 : this.importManifestUrl().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImageDetail)) {
            return false;
        }
        DiskImageDetail other = (DiskImageDetail)obj;
        if (other.bytes() == null ^ this.bytes() == null) {
            return false;
        }
        if (other.bytes() != null && !other.bytes().equals(this.bytes())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.importManifestUrl() == null ^ this.importManifestUrl() == null) {
            return false;
        }
        return other.importManifestUrl() == null || other.importManifestUrl().equals(this.importManifestUrl());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bytes() != null) {
            sb.append("Bytes: ").append(this.bytes()).append(",");
        }
        if (this.format() != null) {
            sb.append("Format: ").append(this.format()).append(",");
        }
        if (this.importManifestUrl() != null) {
            sb.append("ImportManifestUrl: ").append(this.importManifestUrl()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Long bytes;
        private String format;
        private String importManifestUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImageDetail model) {
            this.setBytes(model.bytes);
            this.setFormat(model.format);
            this.setImportManifestUrl(model.importManifestUrl);
        }

        public final Long getBytes() {
            return this.bytes;
        }

        @Override
        public final Builder bytes(Long bytes) {
            this.bytes = bytes;
            return this;
        }

        public final void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(DiskImageFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final void setFormat(DiskImageFormat format) {
            this.format(format.toString());
        }

        public final String getImportManifestUrl() {
            return this.importManifestUrl;
        }

        @Override
        public final Builder importManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
            return this;
        }

        public final void setImportManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
        }

        public DiskImageDetail build() {
            return new DiskImageDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DiskImageDetail> {
        public Builder bytes(Long var1);

        public Builder format(String var1);

        public Builder format(DiskImageFormat var1);

        public Builder importManifestUrl(String var1);
    }
}

