/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.VpcClassicLinkIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeVpcClassicLinkDnsSupportRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportRequest> {
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> vpcIds;

    private DescribeVpcClassicLinkDnsSupportRequest(BuilderImpl builder) {
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.vpcIds = builder.vpcIds;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> vpcIds() {
        return this.vpcIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.vpcIds() == null ? 0 : this.vpcIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkDnsSupportRequest)) {
            return false;
        }
        DescribeVpcClassicLinkDnsSupportRequest other = (DescribeVpcClassicLinkDnsSupportRequest)((Object)obj);
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.vpcIds() == null ^ this.vpcIds() == null) {
            return false;
        }
        return other.vpcIds() == null || other.vpcIds().equals(this.vpcIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.vpcIds() != null) {
            sb.append("VpcIds: ").append(this.vpcIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private List<String> vpcIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkDnsSupportRequest model) {
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setVpcIds(model.vpcIds);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getVpcIds() {
            return this.vpcIds;
        }

        @Override
        public final Builder vpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcIds(String ... vpcIds) {
            this.vpcIds(Arrays.asList(vpcIds));
            return this;
        }

        public final void setVpcIds(Collection<String> vpcIds) {
            this.vpcIds = VpcClassicLinkIdListCopier.copy(vpcIds);
        }

        @SafeVarargs
        public final void setVpcIds(String ... vpcIds) {
            this.vpcIds(Arrays.asList(vpcIds));
        }

        public DescribeVpcClassicLinkDnsSupportRequest build() {
            return new DescribeVpcClassicLinkDnsSupportRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder vpcIds(Collection<String> var1);

        public Builder vpcIds(String ... var1);
    }
}

