/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.OwnerStringListCopier;
import software.amazon.awssdk.services.ec2.model.RestorableByStringListCopier;
import software.amazon.awssdk.services.ec2.model.SnapshotIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSnapshotsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeSnapshotsRequest> {
    private final List<Filter> filters;
    private final Integer maxResults;
    private final String nextToken;
    private final List<String> ownerIds;
    private final List<String> restorableByUserIds;
    private final List<String> snapshotIds;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ownerIds = builder.ownerIds;
        this.restorableByUserIds = builder.restorableByUserIds;
        this.snapshotIds = builder.snapshotIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<String> ownerIds() {
        return this.ownerIds;
    }

    public List<String> restorableByUserIds() {
        return this.restorableByUserIds;
    }

    public List<String> snapshotIds() {
        return this.snapshotIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.ownerIds() == null ? 0 : this.ownerIds().hashCode());
        hashCode = 31 * hashCode + (this.restorableByUserIds() == null ? 0 : this.restorableByUserIds().hashCode());
        hashCode = 31 * hashCode + (this.snapshotIds() == null ? 0 : this.snapshotIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.ownerIds() == null ^ this.ownerIds() == null) {
            return false;
        }
        if (other.ownerIds() != null && !other.ownerIds().equals(this.ownerIds())) {
            return false;
        }
        if (other.restorableByUserIds() == null ^ this.restorableByUserIds() == null) {
            return false;
        }
        if (other.restorableByUserIds() != null && !other.restorableByUserIds().equals(this.restorableByUserIds())) {
            return false;
        }
        if (other.snapshotIds() == null ^ this.snapshotIds() == null) {
            return false;
        }
        return other.snapshotIds() == null || other.snapshotIds().equals(this.snapshotIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.ownerIds() != null) {
            sb.append("OwnerIds: ").append(this.ownerIds()).append(",");
        }
        if (this.restorableByUserIds() != null) {
            sb.append("RestorableByUserIds: ").append(this.restorableByUserIds()).append(",");
        }
        if (this.snapshotIds() != null) {
            sb.append("SnapshotIds: ").append(this.snapshotIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private Integer maxResults;
        private String nextToken;
        private List<String> ownerIds;
        private List<String> restorableByUserIds;
        private List<String> snapshotIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            this.setFilters(model.filters);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setOwnerIds(model.ownerIds);
            this.setRestorableByUserIds(model.restorableByUserIds);
            this.setSnapshotIds(model.snapshotIds);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getOwnerIds() {
            return this.ownerIds;
        }

        @Override
        public final Builder ownerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ownerIds(String ... ownerIds) {
            this.ownerIds(Arrays.asList(ownerIds));
            return this;
        }

        public final void setOwnerIds(Collection<String> ownerIds) {
            this.ownerIds = OwnerStringListCopier.copy(ownerIds);
        }

        @SafeVarargs
        public final void setOwnerIds(String ... ownerIds) {
            this.ownerIds(Arrays.asList(ownerIds));
        }

        public final Collection<String> getRestorableByUserIds() {
            return this.restorableByUserIds;
        }

        @Override
        public final Builder restorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder restorableByUserIds(String ... restorableByUserIds) {
            this.restorableByUserIds(Arrays.asList(restorableByUserIds));
            return this;
        }

        public final void setRestorableByUserIds(Collection<String> restorableByUserIds) {
            this.restorableByUserIds = RestorableByStringListCopier.copy(restorableByUserIds);
        }

        @SafeVarargs
        public final void setRestorableByUserIds(String ... restorableByUserIds) {
            this.restorableByUserIds(Arrays.asList(restorableByUserIds));
        }

        public final Collection<String> getSnapshotIds() {
            return this.snapshotIds;
        }

        @Override
        public final Builder snapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIds(String ... snapshotIds) {
            this.snapshotIds(Arrays.asList(snapshotIds));
            return this;
        }

        public final void setSnapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdStringListCopier.copy(snapshotIds);
        }

        @SafeVarargs
        public final void setSnapshotIds(String ... snapshotIds) {
            this.snapshotIds(Arrays.asList(snapshotIds));
        }

        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder ownerIds(Collection<String> var1);

        public Builder ownerIds(String ... var1);

        public Builder restorableByUserIds(Collection<String> var1);

        public Builder restorableByUserIds(String ... var1);

        public Builder snapshotIds(Collection<String> var1);

        public Builder snapshotIds(String ... var1);
    }
}

