/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRouteTablesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeRouteTablesRequest> {
    private final List<Filter> filters;
    private final List<String> routeTableIds;

    private DescribeRouteTablesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.routeTableIds = builder.routeTableIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> routeTableIds() {
        return this.routeTableIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.routeTableIds() == null ? 0 : this.routeTableIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteTablesRequest)) {
            return false;
        }
        DescribeRouteTablesRequest other = (DescribeRouteTablesRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.routeTableIds() == null ^ this.routeTableIds() == null) {
            return false;
        }
        return other.routeTableIds() == null || other.routeTableIds().equals(this.routeTableIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.routeTableIds() != null) {
            sb.append("RouteTableIds: ").append(this.routeTableIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> routeTableIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteTablesRequest model) {
            this.setFilters(model.filters);
            this.setRouteTableIds(model.routeTableIds);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Collection<String> getRouteTableIds() {
            return this.routeTableIds;
        }

        @Override
        public final Builder routeTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTableIds(String ... routeTableIds) {
            this.routeTableIds(Arrays.asList(routeTableIds));
            return this;
        }

        public final void setRouteTableIds(Collection<String> routeTableIds) {
            this.routeTableIds = ValueStringListCopier.copy(routeTableIds);
        }

        @SafeVarargs
        public final void setRouteTableIds(String ... routeTableIds) {
            this.routeTableIds(Arrays.asList(routeTableIds));
        }

        public DescribeRouteTablesRequest build() {
            return new DescribeRouteTablesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRouteTablesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder routeTableIds(Collection<String> var1);

        public Builder routeTableIds(String ... var1);
    }
}

