/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOfferingIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesOfferingsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeReservedInstancesOfferingsRequest> {
    private final String availabilityZone;
    private final List<Filter> filters;
    private final Boolean includeMarketplace;
    private final String instanceType;
    private final Long maxDuration;
    private final Integer maxInstanceCount;
    private final Long minDuration;
    private final String offeringClass;
    private final String productDescription;
    private final List<String> reservedInstancesOfferingIds;
    private final String instanceTenancy;
    private final Integer maxResults;
    private final String nextToken;
    private final String offeringType;

    private DescribeReservedInstancesOfferingsRequest(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.filters = builder.filters;
        this.includeMarketplace = builder.includeMarketplace;
        this.instanceType = builder.instanceType;
        this.maxDuration = builder.maxDuration;
        this.maxInstanceCount = builder.maxInstanceCount;
        this.minDuration = builder.minDuration;
        this.offeringClass = builder.offeringClass;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingIds = builder.reservedInstancesOfferingIds;
        this.instanceTenancy = builder.instanceTenancy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.offeringType = builder.offeringType;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Boolean includeMarketplace() {
        return this.includeMarketplace;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Long maxDuration() {
        return this.maxDuration;
    }

    public Integer maxInstanceCount() {
        return this.maxInstanceCount;
    }

    public Long minDuration() {
        return this.minDuration;
    }

    public String offeringClass() {
        return this.offeringClass;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public List<String> reservedInstancesOfferingIds() {
        return this.reservedInstancesOfferingIds;
    }

    public String instanceTenancy() {
        return this.instanceTenancy;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.includeMarketplace() == null ? 0 : this.includeMarketplace().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.maxDuration() == null ? 0 : this.maxDuration().hashCode());
        hashCode = 31 * hashCode + (this.maxInstanceCount() == null ? 0 : this.maxInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.minDuration() == null ? 0 : this.minDuration().hashCode());
        hashCode = 31 * hashCode + (this.offeringClass() == null ? 0 : this.offeringClass().hashCode());
        hashCode = 31 * hashCode + (this.productDescription() == null ? 0 : this.productDescription().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesOfferingIds() == null ? 0 : this.reservedInstancesOfferingIds().hashCode());
        hashCode = 31 * hashCode + (this.instanceTenancy() == null ? 0 : this.instanceTenancy().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.offeringType() == null ? 0 : this.offeringType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsRequest)) {
            return false;
        }
        DescribeReservedInstancesOfferingsRequest other = (DescribeReservedInstancesOfferingsRequest)((Object)obj);
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.includeMarketplace() == null ^ this.includeMarketplace() == null) {
            return false;
        }
        if (other.includeMarketplace() != null && !other.includeMarketplace().equals(this.includeMarketplace())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.maxDuration() == null ^ this.maxDuration() == null) {
            return false;
        }
        if (other.maxDuration() != null && !other.maxDuration().equals(this.maxDuration())) {
            return false;
        }
        if (other.maxInstanceCount() == null ^ this.maxInstanceCount() == null) {
            return false;
        }
        if (other.maxInstanceCount() != null && !other.maxInstanceCount().equals(this.maxInstanceCount())) {
            return false;
        }
        if (other.minDuration() == null ^ this.minDuration() == null) {
            return false;
        }
        if (other.minDuration() != null && !other.minDuration().equals(this.minDuration())) {
            return false;
        }
        if (other.offeringClass() == null ^ this.offeringClass() == null) {
            return false;
        }
        if (other.offeringClass() != null && !other.offeringClass().equals(this.offeringClass())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.reservedInstancesOfferingIds() == null ^ this.reservedInstancesOfferingIds() == null) {
            return false;
        }
        if (other.reservedInstancesOfferingIds() != null && !other.reservedInstancesOfferingIds().equals(this.reservedInstancesOfferingIds())) {
            return false;
        }
        if (other.instanceTenancy() == null ^ this.instanceTenancy() == null) {
            return false;
        }
        if (other.instanceTenancy() != null && !other.instanceTenancy().equals(this.instanceTenancy())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        if (other.maxResults() != null && !other.maxResults().equals(this.maxResults())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        return other.offeringType() == null || other.offeringType().equals(this.offeringType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.includeMarketplace() != null) {
            sb.append("IncludeMarketplace: ").append(this.includeMarketplace()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.maxDuration() != null) {
            sb.append("MaxDuration: ").append(this.maxDuration()).append(",");
        }
        if (this.maxInstanceCount() != null) {
            sb.append("MaxInstanceCount: ").append(this.maxInstanceCount()).append(",");
        }
        if (this.minDuration() != null) {
            sb.append("MinDuration: ").append(this.minDuration()).append(",");
        }
        if (this.offeringClass() != null) {
            sb.append("OfferingClass: ").append(this.offeringClass()).append(",");
        }
        if (this.productDescription() != null) {
            sb.append("ProductDescription: ").append(this.productDescription()).append(",");
        }
        if (this.reservedInstancesOfferingIds() != null) {
            sb.append("ReservedInstancesOfferingIds: ").append(this.reservedInstancesOfferingIds()).append(",");
        }
        if (this.instanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(this.instanceTenancy()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.offeringType() != null) {
            sb.append("OfferingType: ").append(this.offeringType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<Filter> filters;
        private Boolean includeMarketplace;
        private String instanceType;
        private Long maxDuration;
        private Integer maxInstanceCount;
        private Long minDuration;
        private String offeringClass;
        private String productDescription;
        private List<String> reservedInstancesOfferingIds;
        private String instanceTenancy;
        private Integer maxResults;
        private String nextToken;
        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsRequest model) {
            this.setAvailabilityZone(model.availabilityZone);
            this.setFilters(model.filters);
            this.setIncludeMarketplace(model.includeMarketplace);
            this.setInstanceType(model.instanceType);
            this.setMaxDuration(model.maxDuration);
            this.setMaxInstanceCount(model.maxInstanceCount);
            this.setMinDuration(model.minDuration);
            this.setOfferingClass(model.offeringClass);
            this.setProductDescription(model.productDescription);
            this.setReservedInstancesOfferingIds(model.reservedInstancesOfferingIds);
            this.setInstanceTenancy(model.instanceTenancy);
            this.setMaxResults(model.maxResults);
            this.setNextToken(model.nextToken);
            this.setOfferingType(model.offeringType);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Boolean getIncludeMarketplace() {
            return this.includeMarketplace;
        }

        @Override
        public final Builder includeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
            return this;
        }

        public final void setIncludeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final Long getMaxDuration() {
            return this.maxDuration;
        }

        @Override
        public final Builder maxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final void setMaxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
        }

        public final Integer getMaxInstanceCount() {
            return this.maxInstanceCount;
        }

        @Override
        public final Builder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        public final void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        public final Long getMinDuration() {
            return this.minDuration;
        }

        @Override
        public final Builder minDuration(Long minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final void setMinDuration(Long minDuration) {
            this.minDuration = minDuration;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public final void setOfferingClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass.toString());
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final void setProductDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription.toString());
        }

        public final Collection<String> getReservedInstancesOfferingIds() {
            return this.reservedInstancesOfferingIds;
        }

        @Override
        public final Builder reservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesOfferingIds(String ... reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds(Arrays.asList(reservedInstancesOfferingIds));
            return this;
        }

        public final void setReservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
        }

        @SafeVarargs
        public final void setReservedInstancesOfferingIds(String ... reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds(Arrays.asList(reservedInstancesOfferingIds));
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        @Override
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
            return this;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        public final void setInstanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy.toString());
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final void setOfferingType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType.toString());
        }

        public DescribeReservedInstancesOfferingsRequest build() {
            return new DescribeReservedInstancesOfferingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedInstancesOfferingsRequest> {
        public Builder availabilityZone(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder includeMarketplace(Boolean var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder maxDuration(Long var1);

        public Builder maxInstanceCount(Integer var1);

        public Builder minDuration(Long var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder reservedInstancesOfferingIds(Collection<String> var1);

        public Builder reservedInstancesOfferingIds(String ... var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);
    }
}

