/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModification;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedInstancesModificationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReservedInstancesModificationsResponse> {
    private final String nextToken;
    private final List<ReservedInstancesModification> reservedInstancesModifications;

    private DescribeReservedInstancesModificationsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.reservedInstancesModifications = builder.reservedInstancesModifications;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<ReservedInstancesModification> reservedInstancesModifications() {
        return this.reservedInstancesModifications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.reservedInstancesModifications() == null ? 0 : this.reservedInstancesModifications().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesModificationsResponse)) {
            return false;
        }
        DescribeReservedInstancesModificationsResponse other = (DescribeReservedInstancesModificationsResponse)((Object)obj);
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.reservedInstancesModifications() == null ^ this.reservedInstancesModifications() == null) {
            return false;
        }
        return other.reservedInstancesModifications() == null || other.reservedInstancesModifications().equals(this.reservedInstancesModifications());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.reservedInstancesModifications() != null) {
            sb.append("ReservedInstancesModifications: ").append(this.reservedInstancesModifications()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedInstancesModification> reservedInstancesModifications;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesModificationsResponse model) {
            this.setNextToken(model.nextToken);
            this.setReservedInstancesModifications(model.reservedInstancesModifications);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ReservedInstancesModification> getReservedInstancesModifications() {
            return this.reservedInstancesModifications;
        }

        @Override
        public final Builder reservedInstancesModifications(Collection<ReservedInstancesModification> reservedInstancesModifications) {
            this.reservedInstancesModifications = ReservedInstancesModificationListCopier.copy(reservedInstancesModifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesModifications(ReservedInstancesModification ... reservedInstancesModifications) {
            this.reservedInstancesModifications(Arrays.asList(reservedInstancesModifications));
            return this;
        }

        public final void setReservedInstancesModifications(Collection<ReservedInstancesModification> reservedInstancesModifications) {
            this.reservedInstancesModifications = ReservedInstancesModificationListCopier.copy(reservedInstancesModifications);
        }

        @SafeVarargs
        public final void setReservedInstancesModifications(ReservedInstancesModification ... reservedInstancesModifications) {
            this.reservedInstancesModifications(Arrays.asList(reservedInstancesModifications));
        }

        public DescribeReservedInstancesModificationsResponse build() {
            return new DescribeReservedInstancesModificationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedInstancesModificationsResponse> {
        public Builder nextToken(String var1);

        public Builder reservedInstancesModifications(Collection<ReservedInstancesModification> var1);

        public Builder reservedInstancesModifications(ReservedInstancesModification ... var1);
    }
}

