/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNetworkAclsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeNetworkAclsRequest> {
    private final List<Filter> filters;
    private final List<String> networkAclIds;

    private DescribeNetworkAclsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.networkAclIds = builder.networkAclIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> networkAclIds() {
        return this.networkAclIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.networkAclIds() == null ? 0 : this.networkAclIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkAclsRequest)) {
            return false;
        }
        DescribeNetworkAclsRequest other = (DescribeNetworkAclsRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.networkAclIds() == null ^ this.networkAclIds() == null) {
            return false;
        }
        return other.networkAclIds() == null || other.networkAclIds().equals(this.networkAclIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.networkAclIds() != null) {
            sb.append("NetworkAclIds: ").append(this.networkAclIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> networkAclIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNetworkAclsRequest model) {
            this.setFilters(model.filters);
            this.setNetworkAclIds(model.networkAclIds);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Collection<String> getNetworkAclIds() {
            return this.networkAclIds;
        }

        @Override
        public final Builder networkAclIds(Collection<String> networkAclIds) {
            this.networkAclIds = ValueStringListCopier.copy(networkAclIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkAclIds(String ... networkAclIds) {
            this.networkAclIds(Arrays.asList(networkAclIds));
            return this;
        }

        public final void setNetworkAclIds(Collection<String> networkAclIds) {
            this.networkAclIds = ValueStringListCopier.copy(networkAclIds);
        }

        @SafeVarargs
        public final void setNetworkAclIds(String ... networkAclIds) {
            this.networkAclIds(Arrays.asList(networkAclIds));
        }

        public DescribeNetworkAclsRequest build() {
            return new DescribeNetworkAclsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNetworkAclsRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder networkAclIds(Collection<String> var1);

        public Builder networkAclIds(String ... var1);
    }
}

