/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ec2.model.InstanceStatus;
import software.amazon.awssdk.services.ec2.model.InstanceStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeInstanceStatusResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeInstanceStatusResponse> {
    private final List<InstanceStatus> instanceStatuses;
    private final String nextToken;

    private DescribeInstanceStatusResponse(BuilderImpl builder) {
        this.instanceStatuses = builder.instanceStatuses;
        this.nextToken = builder.nextToken;
    }

    public List<InstanceStatus> instanceStatuses() {
        return this.instanceStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceStatuses() == null ? 0 : this.instanceStatuses().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceStatusResponse)) {
            return false;
        }
        DescribeInstanceStatusResponse other = (DescribeInstanceStatusResponse)((Object)obj);
        if (other.instanceStatuses() == null ^ this.instanceStatuses() == null) {
            return false;
        }
        if (other.instanceStatuses() != null && !other.instanceStatuses().equals(this.instanceStatuses())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceStatuses() != null) {
            sb.append("InstanceStatuses: ").append(this.instanceStatuses()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<InstanceStatus> instanceStatuses;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceStatusResponse model) {
            this.setInstanceStatuses(model.instanceStatuses);
            this.setNextToken(model.nextToken);
        }

        public final Collection<InstanceStatus> getInstanceStatuses() {
            return this.instanceStatuses;
        }

        @Override
        public final Builder instanceStatuses(Collection<InstanceStatus> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copy(instanceStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatuses(InstanceStatus ... instanceStatuses) {
            this.instanceStatuses(Arrays.asList(instanceStatuses));
            return this;
        }

        public final void setInstanceStatuses(Collection<InstanceStatus> instanceStatuses) {
            this.instanceStatuses = InstanceStatusListCopier.copy(instanceStatuses);
        }

        @SafeVarargs
        public final void setInstanceStatuses(InstanceStatus ... instanceStatuses) {
            this.instanceStatuses(Arrays.asList(instanceStatuses));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeInstanceStatusResponse build() {
            return new DescribeInstanceStatusResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeInstanceStatusResponse> {
        public Builder instanceStatuses(Collection<InstanceStatus> var1);

        public Builder instanceStatuses(InstanceStatus ... var1);

        public Builder nextToken(String var1);
    }
}

