/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.ExportTaskIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExportTasksRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeExportTasksRequest> {
    private final List<String> exportTaskIds;

    private DescribeExportTasksRequest(BuilderImpl builder) {
        this.exportTaskIds = builder.exportTaskIds;
    }

    public List<String> exportTaskIds() {
        return this.exportTaskIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.exportTaskIds() == null ? 0 : this.exportTaskIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExportTasksRequest)) {
            return false;
        }
        DescribeExportTasksRequest other = (DescribeExportTasksRequest)((Object)obj);
        if (other.exportTaskIds() == null ^ this.exportTaskIds() == null) {
            return false;
        }
        return other.exportTaskIds() == null || other.exportTaskIds().equals(this.exportTaskIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exportTaskIds() != null) {
            sb.append("ExportTaskIds: ").append(this.exportTaskIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> exportTaskIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExportTasksRequest model) {
            this.setExportTaskIds(model.exportTaskIds);
        }

        public final Collection<String> getExportTaskIds() {
            return this.exportTaskIds;
        }

        @Override
        public final Builder exportTaskIds(Collection<String> exportTaskIds) {
            this.exportTaskIds = ExportTaskIdStringListCopier.copy(exportTaskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportTaskIds(String ... exportTaskIds) {
            this.exportTaskIds(Arrays.asList(exportTaskIds));
            return this;
        }

        public final void setExportTaskIds(Collection<String> exportTaskIds) {
            this.exportTaskIds = ExportTaskIdStringListCopier.copy(exportTaskIds);
        }

        @SafeVarargs
        public final void setExportTaskIds(String ... exportTaskIds) {
            this.exportTaskIds(Arrays.asList(exportTaskIds));
        }

        public DescribeExportTasksRequest build() {
            return new DescribeExportTasksRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeExportTasksRequest> {
        public Builder exportTaskIds(Collection<String> var1);

        public Builder exportTaskIds(String ... var1);
    }
}

