/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.AllocationIdListCopier;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.PublicIpStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAddressesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeAddressesRequest> {
    private final List<Filter> filters;
    private final List<String> publicIps;
    private final List<String> allocationIds;

    private DescribeAddressesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.publicIps = builder.publicIps;
        this.allocationIds = builder.allocationIds;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public List<String> publicIps() {
        return this.publicIps;
    }

    public List<String> allocationIds() {
        return this.allocationIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.publicIps() == null ? 0 : this.publicIps().hashCode());
        hashCode = 31 * hashCode + (this.allocationIds() == null ? 0 : this.allocationIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAddressesRequest)) {
            return false;
        }
        DescribeAddressesRequest other = (DescribeAddressesRequest)((Object)obj);
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.publicIps() == null ^ this.publicIps() == null) {
            return false;
        }
        if (other.publicIps() != null && !other.publicIps().equals(this.publicIps())) {
            return false;
        }
        if (other.allocationIds() == null ^ this.allocationIds() == null) {
            return false;
        }
        return other.allocationIds() == null || other.allocationIds().equals(this.allocationIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.publicIps() != null) {
            sb.append("PublicIps: ").append(this.publicIps()).append(",");
        }
        if (this.allocationIds() != null) {
            sb.append("AllocationIds: ").append(this.allocationIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Filter> filters;
        private List<String> publicIps;
        private List<String> allocationIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAddressesRequest model) {
            this.setFilters(model.filters);
            this.setPublicIps(model.publicIps);
            this.setAllocationIds(model.allocationIds);
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Collection<String> getPublicIps() {
            return this.publicIps;
        }

        @Override
        public final Builder publicIps(Collection<String> publicIps) {
            this.publicIps = PublicIpStringListCopier.copy(publicIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicIps(String ... publicIps) {
            this.publicIps(Arrays.asList(publicIps));
            return this;
        }

        public final void setPublicIps(Collection<String> publicIps) {
            this.publicIps = PublicIpStringListCopier.copy(publicIps);
        }

        @SafeVarargs
        public final void setPublicIps(String ... publicIps) {
            this.publicIps(Arrays.asList(publicIps));
        }

        public final Collection<String> getAllocationIds() {
            return this.allocationIds;
        }

        @Override
        public final Builder allocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationIds(String ... allocationIds) {
            this.allocationIds(Arrays.asList(allocationIds));
            return this;
        }

        public final void setAllocationIds(Collection<String> allocationIds) {
            this.allocationIds = AllocationIdListCopier.copy(allocationIds);
        }

        @SafeVarargs
        public final void setAllocationIds(String ... allocationIds) {
            this.allocationIds(Arrays.asList(allocationIds));
        }

        public DescribeAddressesRequest build() {
            return new DescribeAddressesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAddressesRequest> {
        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder publicIps(Collection<String> var1);

        public Builder publicIps(String ... var1);

        public Builder allocationIds(Collection<String> var1);

        public Builder allocationIds(String ... var1);
    }
}

