/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CustomerGateway
implements ToCopyableBuilder<Builder, CustomerGateway> {
    private final String bgpAsn;
    private final String customerGatewayId;
    private final String ipAddress;
    private final String state;
    private final String type;
    private final List<Tag> tags;

    private CustomerGateway(BuilderImpl builder) {
        this.bgpAsn = builder.bgpAsn;
        this.customerGatewayId = builder.customerGatewayId;
        this.ipAddress = builder.ipAddress;
        this.state = builder.state;
        this.type = builder.type;
        this.tags = builder.tags;
    }

    public String bgpAsn() {
        return this.bgpAsn;
    }

    public String customerGatewayId() {
        return this.customerGatewayId;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public String state() {
        return this.state;
    }

    public String type() {
        return this.type;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bgpAsn() == null ? 0 : this.bgpAsn().hashCode());
        hashCode = 31 * hashCode + (this.customerGatewayId() == null ? 0 : this.customerGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.ipAddress() == null ? 0 : this.ipAddress().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerGateway)) {
            return false;
        }
        CustomerGateway other = (CustomerGateway)obj;
        if (other.bgpAsn() == null ^ this.bgpAsn() == null) {
            return false;
        }
        if (other.bgpAsn() != null && !other.bgpAsn().equals(this.bgpAsn())) {
            return false;
        }
        if (other.customerGatewayId() == null ^ this.customerGatewayId() == null) {
            return false;
        }
        if (other.customerGatewayId() != null && !other.customerGatewayId().equals(this.customerGatewayId())) {
            return false;
        }
        if (other.ipAddress() == null ^ this.ipAddress() == null) {
            return false;
        }
        if (other.ipAddress() != null && !other.ipAddress().equals(this.ipAddress())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bgpAsn() != null) {
            sb.append("BgpAsn: ").append(this.bgpAsn()).append(",");
        }
        if (this.customerGatewayId() != null) {
            sb.append("CustomerGatewayId: ").append(this.customerGatewayId()).append(",");
        }
        if (this.ipAddress() != null) {
            sb.append("IpAddress: ").append(this.ipAddress()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String bgpAsn;
        private String customerGatewayId;
        private String ipAddress;
        private String state;
        private String type;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerGateway model) {
            this.setBgpAsn(model.bgpAsn);
            this.setCustomerGatewayId(model.customerGatewayId);
            this.setIpAddress(model.ipAddress);
            this.setState(model.state);
            this.setType(model.type);
            this.setTags(model.tags);
        }

        public final String getBgpAsn() {
            return this.bgpAsn;
        }

        @Override
        public final Builder bgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final void setBgpAsn(String bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        public final String getCustomerGatewayId() {
            return this.customerGatewayId;
        }

        @Override
        public final Builder customerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
            return this;
        }

        public final void setCustomerGatewayId(String customerGatewayId) {
            this.customerGatewayId = customerGatewayId;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
        }

        public CustomerGateway build() {
            return new CustomerGateway(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CustomerGateway> {
        public Builder bgpAsn(String var1);

        public Builder customerGatewayId(String var1);

        public Builder ipAddress(String var1);

        public Builder state(String var1);

        public Builder type(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

