/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;
import software.amazon.awssdk.services.ec2.model.NewDhcpConfigurationListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDhcpOptionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDhcpOptionsRequest> {
    private final List<DhcpConfiguration> dhcpConfigurations;

    private CreateDhcpOptionsRequest(BuilderImpl builder) {
        this.dhcpConfigurations = builder.dhcpConfigurations;
    }

    public List<DhcpConfiguration> dhcpConfigurations() {
        return this.dhcpConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dhcpConfigurations() == null ? 0 : this.dhcpConfigurations().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsRequest)) {
            return false;
        }
        CreateDhcpOptionsRequest other = (CreateDhcpOptionsRequest)((Object)obj);
        if (other.dhcpConfigurations() == null ^ this.dhcpConfigurations() == null) {
            return false;
        }
        return other.dhcpConfigurations() == null || other.dhcpConfigurations().equals(this.dhcpConfigurations());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dhcpConfigurations() != null) {
            sb.append("DhcpConfigurations: ").append(this.dhcpConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<DhcpConfiguration> dhcpConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDhcpOptionsRequest model) {
            this.setDhcpConfigurations(model.dhcpConfigurations);
        }

        public final Collection<DhcpConfiguration> getDhcpConfigurations() {
            return this.dhcpConfigurations;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
            this.dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        public final void setDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copy(dhcpConfigurations);
        }

        @SafeVarargs
        public final void setDhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
            this.dhcpConfigurations(Arrays.asList(dhcpConfigurations));
        }

        public CreateDhcpOptionsRequest build() {
            return new CreateDhcpOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDhcpOptionsRequest> {
        public Builder dhcpConfigurations(Collection<DhcpConfiguration> var1);

        public Builder dhcpConfigurations(DhcpConfiguration ... var1);
    }
}

