/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Address
implements ToCopyableBuilder<Builder, Address> {
    private final String instanceId;
    private final String publicIp;
    private final String allocationId;
    private final String associationId;
    private final String domain;
    private final String networkInterfaceId;
    private final String networkInterfaceOwnerId;
    private final String privateIpAddress;

    private Address(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.domain = builder.domain;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfaceOwnerId = builder.networkInterfaceOwnerId;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String associationId() {
        return this.associationId;
    }

    public String domain() {
        return this.domain;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String networkInterfaceOwnerId() {
        return this.networkInterfaceOwnerId;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.publicIp() == null ? 0 : this.publicIp().hashCode());
        hashCode = 31 * hashCode + (this.allocationId() == null ? 0 : this.allocationId().hashCode());
        hashCode = 31 * hashCode + (this.associationId() == null ? 0 : this.associationId().hashCode());
        hashCode = 31 * hashCode + (this.domain() == null ? 0 : this.domain().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.networkInterfaceOwnerId() == null ? 0 : this.networkInterfaceOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddress() == null ? 0 : this.privateIpAddress().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.allocationId() == null ^ this.allocationId() == null) {
            return false;
        }
        if (other.allocationId() != null && !other.allocationId().equals(this.allocationId())) {
            return false;
        }
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        if (other.domain() == null ^ this.domain() == null) {
            return false;
        }
        if (other.domain() != null && !other.domain().equals(this.domain())) {
            return false;
        }
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.networkInterfaceOwnerId() == null ^ this.networkInterfaceOwnerId() == null) {
            return false;
        }
        if (other.networkInterfaceOwnerId() != null && !other.networkInterfaceOwnerId().equals(this.networkInterfaceOwnerId())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        return other.privateIpAddress() == null || other.privateIpAddress().equals(this.privateIpAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.publicIp() != null) {
            sb.append("PublicIp: ").append(this.publicIp()).append(",");
        }
        if (this.allocationId() != null) {
            sb.append("AllocationId: ").append(this.allocationId()).append(",");
        }
        if (this.associationId() != null) {
            sb.append("AssociationId: ").append(this.associationId()).append(",");
        }
        if (this.domain() != null) {
            sb.append("Domain: ").append(this.domain()).append(",");
        }
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.networkInterfaceOwnerId() != null) {
            sb.append("NetworkInterfaceOwnerId: ").append(this.networkInterfaceOwnerId()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String publicIp;
        private String allocationId;
        private String associationId;
        private String domain;
        private String networkInterfaceId;
        private String networkInterfaceOwnerId;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.setInstanceId(model.instanceId);
            this.setPublicIp(model.publicIp);
            this.setAllocationId(model.allocationId);
            this.setAssociationId(model.associationId);
            this.setDomain(model.domain);
            this.setNetworkInterfaceId(model.networkInterfaceId);
            this.setNetworkInterfaceOwnerId(model.networkInterfaceOwnerId);
            this.setPrivateIpAddress(model.privateIpAddress);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getDomain() {
            return this.domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public final Builder domain(DomainType domain) {
            this.domain(domain.toString());
            return this;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        public final void setDomain(DomainType domain) {
            this.domain(domain.toString());
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getNetworkInterfaceOwnerId() {
            return this.networkInterfaceOwnerId;
        }

        @Override
        public final Builder networkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
            return this;
        }

        public final void setNetworkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public Address build() {
            return new Address(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Address> {
        public Builder instanceId(String var1);

        public Builder publicIp(String var1);

        public Builder allocationId(String var1);

        public Builder associationId(String var1);

        public Builder domain(String var1);

        public Builder domain(DomainType var1);

        public Builder networkInterfaceId(String var1);

        public Builder networkInterfaceOwnerId(String var1);

        public Builder privateIpAddress(String var1);
    }
}

