/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.DefaultTargetCapacityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetCapacitySpecificationRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetCapacitySpecificationRequest> {
    private static final SdkField<Integer> TOTAL_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetCapacitySpecificationRequest.getter(TargetCapacitySpecificationRequest::totalTargetCapacity)).setter(TargetCapacitySpecificationRequest.setter(Builder::totalTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTargetCapacity").unmarshallLocationName("TotalTargetCapacity").build()}).build();
    private static final SdkField<Integer> ON_DEMAND_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetCapacitySpecificationRequest.getter(TargetCapacitySpecificationRequest::onDemandTargetCapacity)).setter(TargetCapacitySpecificationRequest.setter(Builder::onDemandTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandTargetCapacity").unmarshallLocationName("OnDemandTargetCapacity").build()}).build();
    private static final SdkField<Integer> SPOT_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(TargetCapacitySpecificationRequest.getter(TargetCapacitySpecificationRequest::spotTargetCapacity)).setter(TargetCapacitySpecificationRequest.setter(Builder::spotTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotTargetCapacity").unmarshallLocationName("SpotTargetCapacity").build()}).build();
    private static final SdkField<String> DEFAULT_TARGET_CAPACITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TargetCapacitySpecificationRequest.getter(TargetCapacitySpecificationRequest::defaultTargetCapacityTypeAsString)).setter(TargetCapacitySpecificationRequest.setter(Builder::defaultTargetCapacityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultTargetCapacityType").unmarshallLocationName("DefaultTargetCapacityType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_TARGET_CAPACITY_FIELD, ON_DEMAND_TARGET_CAPACITY_FIELD, SPOT_TARGET_CAPACITY_FIELD, DEFAULT_TARGET_CAPACITY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer totalTargetCapacity;
    private final Integer onDemandTargetCapacity;
    private final Integer spotTargetCapacity;
    private final String defaultTargetCapacityType;

    private TargetCapacitySpecificationRequest(BuilderImpl builder) {
        this.totalTargetCapacity = builder.totalTargetCapacity;
        this.onDemandTargetCapacity = builder.onDemandTargetCapacity;
        this.spotTargetCapacity = builder.spotTargetCapacity;
        this.defaultTargetCapacityType = builder.defaultTargetCapacityType;
    }

    public Integer totalTargetCapacity() {
        return this.totalTargetCapacity;
    }

    public Integer onDemandTargetCapacity() {
        return this.onDemandTargetCapacity;
    }

    public Integer spotTargetCapacity() {
        return this.spotTargetCapacity;
    }

    public DefaultTargetCapacityType defaultTargetCapacityType() {
        return DefaultTargetCapacityType.fromValue(this.defaultTargetCapacityType);
    }

    public String defaultTargetCapacityTypeAsString() {
        return this.defaultTargetCapacityType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.onDemandTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultTargetCapacityTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetCapacitySpecificationRequest)) {
            return false;
        }
        TargetCapacitySpecificationRequest other = (TargetCapacitySpecificationRequest)obj;
        return Objects.equals(this.totalTargetCapacity(), other.totalTargetCapacity()) && Objects.equals(this.onDemandTargetCapacity(), other.onDemandTargetCapacity()) && Objects.equals(this.spotTargetCapacity(), other.spotTargetCapacity()) && Objects.equals(this.defaultTargetCapacityTypeAsString(), other.defaultTargetCapacityTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"TargetCapacitySpecificationRequest").add("TotalTargetCapacity", (Object)this.totalTargetCapacity()).add("OnDemandTargetCapacity", (Object)this.onDemandTargetCapacity()).add("SpotTargetCapacity", (Object)this.spotTargetCapacity()).add("DefaultTargetCapacityType", (Object)this.defaultTargetCapacityTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalTargetCapacity()));
            }
            case "OnDemandTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.onDemandTargetCapacity()));
            }
            case "SpotTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.spotTargetCapacity()));
            }
            case "DefaultTargetCapacityType": {
                return Optional.ofNullable(clazz.cast(this.defaultTargetCapacityTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetCapacitySpecificationRequest, T> g) {
        return obj -> g.apply((TargetCapacitySpecificationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer totalTargetCapacity;
        private Integer onDemandTargetCapacity;
        private Integer spotTargetCapacity;
        private String defaultTargetCapacityType;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetCapacitySpecificationRequest model) {
            this.totalTargetCapacity(model.totalTargetCapacity);
            this.onDemandTargetCapacity(model.onDemandTargetCapacity);
            this.spotTargetCapacity(model.spotTargetCapacity);
            this.defaultTargetCapacityType(model.defaultTargetCapacityType);
        }

        public final Integer getTotalTargetCapacity() {
            return this.totalTargetCapacity;
        }

        @Override
        public final Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        public final void setTotalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
        }

        public final Integer getOnDemandTargetCapacity() {
            return this.onDemandTargetCapacity;
        }

        @Override
        public final Builder onDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
            return this;
        }

        public final void setOnDemandTargetCapacity(Integer onDemandTargetCapacity) {
            this.onDemandTargetCapacity = onDemandTargetCapacity;
        }

        public final Integer getSpotTargetCapacity() {
            return this.spotTargetCapacity;
        }

        @Override
        public final Builder spotTargetCapacity(Integer spotTargetCapacity) {
            this.spotTargetCapacity = spotTargetCapacity;
            return this;
        }

        public final void setSpotTargetCapacity(Integer spotTargetCapacity) {
            this.spotTargetCapacity = spotTargetCapacity;
        }

        public final String getDefaultTargetCapacityType() {
            return this.defaultTargetCapacityType;
        }

        @Override
        public final Builder defaultTargetCapacityType(String defaultTargetCapacityType) {
            this.defaultTargetCapacityType = defaultTargetCapacityType;
            return this;
        }

        @Override
        public final Builder defaultTargetCapacityType(DefaultTargetCapacityType defaultTargetCapacityType) {
            this.defaultTargetCapacityType(defaultTargetCapacityType.toString());
            return this;
        }

        public final void setDefaultTargetCapacityType(String defaultTargetCapacityType) {
            this.defaultTargetCapacityType = defaultTargetCapacityType;
        }

        public TargetCapacitySpecificationRequest build() {
            return new TargetCapacitySpecificationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetCapacitySpecificationRequest> {
        public Builder totalTargetCapacity(Integer var1);

        public Builder onDemandTargetCapacity(Integer var1);

        public Builder spotTargetCapacity(Integer var1);

        public Builder defaultTargetCapacityType(String var1);

        public Builder defaultTargetCapacityType(DefaultTargetCapacityType var1);
    }
}

