/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.UserBucket;

public class UserBucketUnmarshaller
implements Unmarshaller<UserBucket, StaxUnmarshallerContext> {
    private static final UserBucketUnmarshaller INSTANCE = new UserBucketUnmarshaller();

    public UserBucket unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        UserBucket.Builder userBucket = UserBucket.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("S3Bucket", targetDepth)) {
                    userBucket.s3Bucket(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("S3Key", targetDepth)) continue;
                userBucket.s3Key(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (UserBucket)userBucket.build();
    }

    public static UserBucketUnmarshaller getInstance() {
        return INSTANCE;
    }
}

