/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.SpotOptions;

public class SpotOptionsUnmarshaller
implements Unmarshaller<SpotOptions, StaxUnmarshallerContext> {
    private static final SpotOptionsUnmarshaller INSTANCE = new SpotOptionsUnmarshaller();

    public SpotOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SpotOptions.Builder spotOptions = SpotOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("allocationStrategy", targetDepth)) {
                    spotOptions.allocationStrategy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceInterruptionBehavior", targetDepth)) {
                    spotOptions.instanceInterruptionBehavior(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instancePoolsToUseCount", targetDepth)) continue;
                spotOptions.instancePoolsToUseCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SpotOptions)spotOptions.build();
    }

    public static SpotOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

