/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.SpotOptionsRequest;

public class SpotOptionsRequestUnmarshaller
implements Unmarshaller<SpotOptionsRequest, StaxUnmarshallerContext> {
    private static final SpotOptionsRequestUnmarshaller INSTANCE = new SpotOptionsRequestUnmarshaller();

    public SpotOptionsRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SpotOptionsRequest.Builder spotOptionsRequest = SpotOptionsRequest.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AllocationStrategy", targetDepth)) {
                    spotOptionsRequest.allocationStrategy(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceInterruptionBehavior", targetDepth)) {
                    spotOptionsRequest.instanceInterruptionBehavior(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("InstancePoolsToUseCount", targetDepth)) continue;
                spotOptionsRequest.instancePoolsToUseCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SpotOptionsRequest)spotOptionsRequest.build();
    }

    public static SpotOptionsRequestUnmarshaller getInstance() {
        return INSTANCE;
    }
}

