/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ServiceConfiguration;
import software.amazon.awssdk.services.ec2.model.ServiceTypeDetail;
import software.amazon.awssdk.services.ec2.transform.ServiceTypeDetailUnmarshaller;

public class ServiceConfigurationUnmarshaller
implements Unmarshaller<ServiceConfiguration, StaxUnmarshallerContext> {
    private static final ServiceConfigurationUnmarshaller INSTANCE = new ServiceConfigurationUnmarshaller();

    public ServiceConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        ServiceConfiguration.Builder serviceConfiguration;
        block16: {
            serviceConfiguration = ServiceConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<ServiceTypeDetail> serviceType = null;
            ArrayList<String> availabilityZones = null;
            ArrayList<String> networkLoadBalancerArns = null;
            ArrayList<String> baseEndpointDnsNames = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    serviceConfiguration.serviceType(serviceType);
                    serviceConfiguration.availabilityZones(availabilityZones);
                    serviceConfiguration.networkLoadBalancerArns(networkLoadBalancerArns);
                    serviceConfiguration.baseEndpointDnsNames(baseEndpointDnsNames);
                    break block16;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("serviceType", targetDepth)) {
                        serviceType = new ArrayList<ServiceTypeDetail>();
                        continue;
                    }
                    if (context.testExpression("serviceType/item", targetDepth)) {
                        serviceType.add(ServiceTypeDetailUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("serviceId", targetDepth)) {
                        serviceConfiguration.serviceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("serviceName", targetDepth)) {
                        serviceConfiguration.serviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("serviceState", targetDepth)) {
                        serviceConfiguration.serviceState(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("availabilityZoneSet", targetDepth)) {
                        availabilityZones = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("availabilityZoneSet/item", targetDepth)) {
                        availabilityZones.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("acceptanceRequired", targetDepth)) {
                        serviceConfiguration.acceptanceRequired(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("networkLoadBalancerArnSet", targetDepth)) {
                        networkLoadBalancerArns = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("networkLoadBalancerArnSet/item", targetDepth)) {
                        networkLoadBalancerArns.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("baseEndpointDnsNameSet", targetDepth)) {
                        baseEndpointDnsNames = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("baseEndpointDnsNameSet/item", targetDepth)) {
                        baseEndpointDnsNames.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("privateDnsName", targetDepth)) continue;
                    serviceConfiguration.privateDnsName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            serviceConfiguration.serviceType(serviceType);
            serviceConfiguration.availabilityZones(availabilityZones);
            serviceConfiguration.networkLoadBalancerArns(networkLoadBalancerArns);
            serviceConfiguration.baseEndpointDnsNames(baseEndpointDnsNames);
        }
        return (ServiceConfiguration)serviceConfiguration.build();
    }

    public static ServiceConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

