/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.RunScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesEbs;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIamInstanceProfile;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesIpv6Address;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesMonitoring;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesPlacement;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;

public class RunScheduledInstancesRequestMarshaller
implements Marshaller<Request<RunScheduledInstancesRequest>, RunScheduledInstancesRequest> {
    /*
     * Could not resolve type clashes
     */
    public Request<RunScheduledInstancesRequest> marshall(RunScheduledInstancesRequest runScheduledInstancesRequest) {
        ScheduledInstancesLaunchSpecification launchSpecification;
        if (runScheduledInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)runScheduledInstancesRequest, "Ec2Client");
        request.addParameter("Action", "RunScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)runScheduledInstancesRequest.clientToken()));
        if (runScheduledInstancesRequest.instanceCount() != null) {
            request.addParameter("InstanceCount", StringConversion.fromInteger((Integer)runScheduledInstancesRequest.instanceCount()));
        }
        if ((launchSpecification = runScheduledInstancesRequest.launchSpecification()) != null) {
            List<String> scheduledInstancesLaunchSpecificationSecurityGroupIdsList;
            ScheduledInstancesPlacement placement;
            List<ScheduledInstancesNetworkInterface> scheduledInstancesLaunchSpecificationNetworkInterfacesList;
            ScheduledInstancesMonitoring monitoring;
            ScheduledInstancesIamInstanceProfile iamInstanceProfile;
            List<ScheduledInstancesBlockDeviceMapping> scheduledInstancesLaunchSpecificationBlockDeviceMappingsList = launchSpecification.blockDeviceMappings();
            if (!scheduledInstancesLaunchSpecificationBlockDeviceMappingsList.isEmpty() || !(scheduledInstancesLaunchSpecificationBlockDeviceMappingsList instanceof SdkAutoConstructList)) {
                int blockDeviceMappingsListIndex = 1;
                for (ScheduledInstancesBlockDeviceMapping scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue : scheduledInstancesLaunchSpecificationBlockDeviceMappingsList) {
                    ScheduledInstancesEbs ebs;
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.deviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.deviceName()));
                    }
                    if ((ebs = scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.ebs()) != null) {
                        if (ebs.deleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)ebs.deleteOnTermination()));
                        }
                        if (ebs.encrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringConversion.fromBoolean((Boolean)ebs.encrypted()));
                        }
                        if (ebs.iops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringConversion.fromInteger((Integer)ebs.iops()));
                        }
                        if (ebs.snapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringConversion.fromString((String)ebs.snapshotId()));
                        }
                        if (ebs.volumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringConversion.fromInteger((Integer)ebs.volumeSize()));
                        }
                        if (ebs.volumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringConversion.fromString((String)ebs.volumeType()));
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.noDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromString((String)scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.noDevice()));
                    }
                    if (scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.virtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)scheduledInstancesLaunchSpecificationBlockDeviceMappingsListValue.virtualName()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (launchSpecification.ebsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringConversion.fromBoolean((Boolean)launchSpecification.ebsOptimized()));
            }
            if ((iamInstanceProfile = launchSpecification.iamInstanceProfile()) != null) {
                if (iamInstanceProfile.arn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringConversion.fromString((String)iamInstanceProfile.arn()));
                }
                if (iamInstanceProfile.name() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringConversion.fromString((String)iamInstanceProfile.name()));
                }
            }
            if (launchSpecification.imageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringConversion.fromString((String)launchSpecification.imageId()));
            }
            if (launchSpecification.instanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringConversion.fromString((String)launchSpecification.instanceType()));
            }
            if (launchSpecification.kernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringConversion.fromString((String)launchSpecification.kernelId()));
            }
            if (launchSpecification.keyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringConversion.fromString((String)launchSpecification.keyName()));
            }
            if ((monitoring = launchSpecification.monitoring()) != null && monitoring.enabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringConversion.fromBoolean((Boolean)monitoring.enabled()));
            }
            if (!(scheduledInstancesLaunchSpecificationNetworkInterfacesList = launchSpecification.networkInterfaces()).isEmpty() || !(scheduledInstancesLaunchSpecificationNetworkInterfacesList instanceof SdkAutoConstructList)) {
                int networkInterfacesListIndex = 1;
                for (ScheduledInstancesNetworkInterface scheduledInstancesLaunchSpecificationNetworkInterfacesListValue : scheduledInstancesLaunchSpecificationNetworkInterfacesList) {
                    List<ScheduledInstancesPrivateIpAddressConfig> scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList;
                    List<ScheduledInstancesIpv6Address> scheduledInstancesNetworkInterfaceIpv6AddressesList;
                    List<String> scheduledInstancesNetworkInterfaceGroupsList;
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringConversion.fromBoolean((Boolean)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.associatePublicIpAddress()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringConversion.fromBoolean((Boolean)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deleteOnTermination()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.description() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringConversion.fromString((String)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.description()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringConversion.fromInteger((Integer)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.deviceIndex()));
                    }
                    if (!(scheduledInstancesNetworkInterfaceGroupsList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.groups()).isEmpty() || !(scheduledInstancesNetworkInterfaceGroupsList instanceof SdkAutoConstructList)) {
                        int groupsListIndex = 1;
                        for (Object scheduledInstancesNetworkInterfaceGroupsListValue : scheduledInstancesNetworkInterfaceGroupsList) {
                            if (scheduledInstancesNetworkInterfaceGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Group." + groupsListIndex, StringConversion.fromString((String)scheduledInstancesNetworkInterfaceGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringConversion.fromInteger((Integer)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.ipv6AddressCount()));
                    }
                    if (!(scheduledInstancesNetworkInterfaceIpv6AddressesList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.ipv6Addresses()).isEmpty() || !(scheduledInstancesNetworkInterfaceIpv6AddressesList instanceof SdkAutoConstructList)) {
                        Object scheduledInstancesNetworkInterfaceGroupsListValue;
                        int ipv6AddressesListIndex = 1;
                        scheduledInstancesNetworkInterfaceGroupsListValue = scheduledInstancesNetworkInterfaceIpv6AddressesList.iterator();
                        while (scheduledInstancesNetworkInterfaceGroupsListValue.hasNext()) {
                            ScheduledInstancesIpv6Address scheduledInstancesNetworkInterfaceIpv6AddressesListValue = (ScheduledInstancesIpv6Address)scheduledInstancesNetworkInterfaceGroupsListValue.next();
                            if (scheduledInstancesNetworkInterfaceIpv6AddressesListValue.ipv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Address." + ipv6AddressesListIndex + ".Ipv6Address", StringConversion.fromString((String)scheduledInstancesNetworkInterfaceIpv6AddressesListValue.ipv6Address()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringConversion.fromString((String)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.networkInterfaceId()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.privateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringConversion.fromString((String)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.privateIpAddress()));
                    }
                    if (!(scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList = scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.privateIpAddressConfigs()).isEmpty() || !(scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList instanceof SdkAutoConstructList)) {
                        int privateIpAddressConfigsListIndex = 1;
                        for (ScheduledInstancesPrivateIpAddressConfig scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue : scheduledInstancesNetworkInterfacePrivateIpAddressConfigsList) {
                            if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.primary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".Primary", StringConversion.fromBoolean((Boolean)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.primary()));
                            }
                            if (scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.privateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".PrivateIpAddress", StringConversion.fromString((String)scheduledInstancesNetworkInterfacePrivateIpAddressConfigsListValue.privateIpAddress()));
                            }
                            ++privateIpAddressConfigsListIndex;
                        }
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringConversion.fromInteger((Integer)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.secondaryPrivateIpAddressCount()));
                    }
                    if (scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.subnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringConversion.fromString((String)scheduledInstancesLaunchSpecificationNetworkInterfacesListValue.subnetId()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((placement = launchSpecification.placement()) != null) {
                if (placement.availabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringConversion.fromString((String)placement.availabilityZone()));
                }
                if (placement.groupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringConversion.fromString((String)placement.groupName()));
                }
            }
            if (launchSpecification.ramdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringConversion.fromString((String)launchSpecification.ramdiskId()));
            }
            if (!(scheduledInstancesLaunchSpecificationSecurityGroupIdsList = launchSpecification.securityGroupIds()).isEmpty() || !(scheduledInstancesLaunchSpecificationSecurityGroupIdsList instanceof SdkAutoConstructList)) {
                int securityGroupIdsListIndex = 1;
                for (String scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue : scheduledInstancesLaunchSpecificationSecurityGroupIdsList) {
                    if (scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroupId." + securityGroupIdsListIndex, StringConversion.fromString((String)scheduledInstancesLaunchSpecificationSecurityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            }
            if (launchSpecification.subnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringConversion.fromString((String)launchSpecification.subnetId()));
            }
            if (launchSpecification.userData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringConversion.fromString((String)launchSpecification.userData()));
            }
        }
        if (runScheduledInstancesRequest.scheduledInstanceId() != null) {
            request.addParameter("ScheduledInstanceId", StringConversion.fromString((String)runScheduledInstancesRequest.scheduledInstanceId()));
        }
        return request;
    }
}

