/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecification;
import software.amazon.awssdk.services.ec2.model.ResponseLaunchTemplateData;
import software.amazon.awssdk.services.ec2.transform.CreditSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ElasticGpuSpecificationResponseUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateBlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateCpuOptionsUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateIamInstanceProfileSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateInstanceMarketOptionsUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateInstanceNetworkInterfaceSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplatePlacementUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateTagSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplatesMonitoringUnmarshaller;

public class ResponseLaunchTemplateDataUnmarshaller
implements Unmarshaller<ResponseLaunchTemplateData, StaxUnmarshallerContext> {
    private static final ResponseLaunchTemplateDataUnmarshaller INSTANCE = new ResponseLaunchTemplateDataUnmarshaller();

    public ResponseLaunchTemplateData unmarshall(StaxUnmarshallerContext context) throws Exception {
        ResponseLaunchTemplateData.Builder responseLaunchTemplateData;
        block30: {
            responseLaunchTemplateData = ResponseLaunchTemplateData.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<LaunchTemplateBlockDeviceMapping> blockDeviceMappings = null;
            ArrayList<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces = null;
            ArrayList<LaunchTemplateTagSpecification> tagSpecifications = null;
            ArrayList<ElasticGpuSpecificationResponse> elasticGpuSpecifications = null;
            ArrayList<String> securityGroupIds = null;
            ArrayList<String> securityGroups = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    responseLaunchTemplateData.blockDeviceMappings(blockDeviceMappings);
                    responseLaunchTemplateData.networkInterfaces(networkInterfaces);
                    responseLaunchTemplateData.tagSpecifications(tagSpecifications);
                    responseLaunchTemplateData.elasticGpuSpecifications(elasticGpuSpecifications);
                    responseLaunchTemplateData.securityGroupIds(securityGroupIds);
                    responseLaunchTemplateData.securityGroups(securityGroups);
                    break block30;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("kernelId", targetDepth)) {
                        responseLaunchTemplateData.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ebsOptimized", targetDepth)) {
                        responseLaunchTemplateData.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("iamInstanceProfile", targetDepth)) {
                        responseLaunchTemplateData.iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("blockDeviceMappingSet", targetDepth)) {
                        blockDeviceMappings = new ArrayList<LaunchTemplateBlockDeviceMapping>();
                        continue;
                    }
                    if (context.testExpression("blockDeviceMappingSet/item", targetDepth)) {
                        blockDeviceMappings.add(LaunchTemplateBlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("networkInterfaceSet", targetDepth)) {
                        networkInterfaces = new ArrayList<LaunchTemplateInstanceNetworkInterfaceSpecification>();
                        continue;
                    }
                    if (context.testExpression("networkInterfaceSet/item", targetDepth)) {
                        networkInterfaces.add(LaunchTemplateInstanceNetworkInterfaceSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("imageId", targetDepth)) {
                        responseLaunchTemplateData.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceType", targetDepth)) {
                        responseLaunchTemplateData.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("keyName", targetDepth)) {
                        responseLaunchTemplateData.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("monitoring", targetDepth)) {
                        responseLaunchTemplateData.monitoring(LaunchTemplatesMonitoringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("placement", targetDepth)) {
                        responseLaunchTemplateData.placement(LaunchTemplatePlacementUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ramDiskId", targetDepth)) {
                        responseLaunchTemplateData.ramDiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("disableApiTermination", targetDepth)) {
                        responseLaunchTemplateData.disableApiTermination(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceInitiatedShutdownBehavior", targetDepth)) {
                        responseLaunchTemplateData.instanceInitiatedShutdownBehavior(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("userData", targetDepth)) {
                        responseLaunchTemplateData.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSpecificationSet", targetDepth)) {
                        tagSpecifications = new ArrayList<LaunchTemplateTagSpecification>();
                        continue;
                    }
                    if (context.testExpression("tagSpecificationSet/item", targetDepth)) {
                        tagSpecifications.add(LaunchTemplateTagSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("elasticGpuSpecificationSet", targetDepth)) {
                        elasticGpuSpecifications = new ArrayList<ElasticGpuSpecificationResponse>();
                        continue;
                    }
                    if (context.testExpression("elasticGpuSpecificationSet/item", targetDepth)) {
                        elasticGpuSpecifications.add(ElasticGpuSpecificationResponseUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("securityGroupIdSet", targetDepth)) {
                        securityGroupIds = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("securityGroupIdSet/item", targetDepth)) {
                        securityGroupIds.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("securityGroupSet", targetDepth)) {
                        securityGroups = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("securityGroupSet/item", targetDepth)) {
                        securityGroups.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instanceMarketOptions", targetDepth)) {
                        responseLaunchTemplateData.instanceMarketOptions(LaunchTemplateInstanceMarketOptionsUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("creditSpecification", targetDepth)) {
                        responseLaunchTemplateData.creditSpecification(CreditSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("cpuOptions", targetDepth)) continue;
                    responseLaunchTemplateData.cpuOptions(LaunchTemplateCpuOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            responseLaunchTemplateData.blockDeviceMappings(blockDeviceMappings);
            responseLaunchTemplateData.networkInterfaces(networkInterfaces);
            responseLaunchTemplateData.tagSpecifications(tagSpecifications);
            responseLaunchTemplateData.elasticGpuSpecifications(elasticGpuSpecifications);
            responseLaunchTemplateData.securityGroupIds(securityGroupIds);
            responseLaunchTemplateData.securityGroups(securityGroups);
        }
        return (ResponseLaunchTemplateData)responseLaunchTemplateData.build();
    }

    public static ResponseLaunchTemplateDataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

