/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ResetImageAttributeRequest;

public class ResetImageAttributeRequestMarshaller
implements Marshaller<Request<ResetImageAttributeRequest>, ResetImageAttributeRequest> {
    public Request<ResetImageAttributeRequest> marshall(ResetImageAttributeRequest resetImageAttributeRequest) {
        if (resetImageAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)resetImageAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ResetImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetImageAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)resetImageAttributeRequest.attributeAsString()));
        }
        if (resetImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringConversion.fromString((String)resetImageAttributeRequest.imageId()));
        }
        return request;
    }
}

