/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.RequestLaunchTemplateData;
import software.amazon.awssdk.services.ec2.transform.CreditSpecificationRequestUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ElasticGpuSpecificationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateBlockDeviceMappingRequestUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateCpuOptionsRequestUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateIamInstanceProfileSpecificationRequestUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateInstanceMarketOptionsRequestUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateInstanceNetworkInterfaceSpecificationRequestUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplatePlacementRequestUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplateTagSpecificationRequestUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.LaunchTemplatesMonitoringRequestUnmarshaller;

public class RequestLaunchTemplateDataUnmarshaller
implements Unmarshaller<RequestLaunchTemplateData, StaxUnmarshallerContext> {
    private static final RequestLaunchTemplateDataUnmarshaller INSTANCE = new RequestLaunchTemplateDataUnmarshaller();

    public RequestLaunchTemplateData unmarshall(StaxUnmarshallerContext context) throws Exception {
        RequestLaunchTemplateData.Builder requestLaunchTemplateData;
        block30: {
            requestLaunchTemplateData = RequestLaunchTemplateData.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings = null;
            ArrayList<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces = null;
            ArrayList<LaunchTemplateTagSpecificationRequest> tagSpecifications = null;
            ArrayList<ElasticGpuSpecification> elasticGpuSpecifications = null;
            ArrayList<String> securityGroupIds = null;
            ArrayList<String> securityGroups = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    requestLaunchTemplateData.blockDeviceMappings(blockDeviceMappings);
                    requestLaunchTemplateData.networkInterfaces(networkInterfaces);
                    requestLaunchTemplateData.tagSpecifications(tagSpecifications);
                    requestLaunchTemplateData.elasticGpuSpecifications(elasticGpuSpecifications);
                    requestLaunchTemplateData.securityGroupIds(securityGroupIds);
                    requestLaunchTemplateData.securityGroups(securityGroups);
                    break block30;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("KernelId", targetDepth)) {
                        requestLaunchTemplateData.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EbsOptimized", targetDepth)) {
                        requestLaunchTemplateData.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IamInstanceProfile", targetDepth)) {
                        requestLaunchTemplateData.iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequestUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("BlockDeviceMapping", targetDepth)) {
                        blockDeviceMappings = new ArrayList<LaunchTemplateBlockDeviceMappingRequest>();
                        continue;
                    }
                    if (context.testExpression("BlockDeviceMapping/BlockDeviceMapping", targetDepth)) {
                        blockDeviceMappings.add(LaunchTemplateBlockDeviceMappingRequestUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NetworkInterface", targetDepth)) {
                        networkInterfaces = new ArrayList<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>();
                        continue;
                    }
                    if (context.testExpression("NetworkInterface/InstanceNetworkInterfaceSpecification", targetDepth)) {
                        networkInterfaces.add(LaunchTemplateInstanceNetworkInterfaceSpecificationRequestUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ImageId", targetDepth)) {
                        requestLaunchTemplateData.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InstanceType", targetDepth)) {
                        requestLaunchTemplateData.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("KeyName", targetDepth)) {
                        requestLaunchTemplateData.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Monitoring", targetDepth)) {
                        requestLaunchTemplateData.monitoring(LaunchTemplatesMonitoringRequestUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Placement", targetDepth)) {
                        requestLaunchTemplateData.placement(LaunchTemplatePlacementRequestUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RamDiskId", targetDepth)) {
                        requestLaunchTemplateData.ramDiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DisableApiTermination", targetDepth)) {
                        requestLaunchTemplateData.disableApiTermination(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InstanceInitiatedShutdownBehavior", targetDepth)) {
                        requestLaunchTemplateData.instanceInitiatedShutdownBehavior(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UserData", targetDepth)) {
                        requestLaunchTemplateData.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TagSpecification", targetDepth)) {
                        tagSpecifications = new ArrayList<LaunchTemplateTagSpecificationRequest>();
                        continue;
                    }
                    if (context.testExpression("TagSpecification/LaunchTemplateTagSpecificationRequest", targetDepth)) {
                        tagSpecifications.add(LaunchTemplateTagSpecificationRequestUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ElasticGpuSpecification", targetDepth)) {
                        elasticGpuSpecifications = new ArrayList<ElasticGpuSpecification>();
                        continue;
                    }
                    if (context.testExpression("ElasticGpuSpecification/ElasticGpuSpecification", targetDepth)) {
                        elasticGpuSpecifications.add(ElasticGpuSpecificationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SecurityGroupId", targetDepth)) {
                        securityGroupIds = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SecurityGroupId/SecurityGroupId", targetDepth)) {
                        securityGroupIds.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SecurityGroup", targetDepth)) {
                        securityGroups = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("SecurityGroup/SecurityGroup", targetDepth)) {
                        securityGroups.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("InstanceMarketOptions", targetDepth)) {
                        requestLaunchTemplateData.instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequestUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreditSpecification", targetDepth)) {
                        requestLaunchTemplateData.creditSpecification(CreditSpecificationRequestUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("CpuOptions", targetDepth)) continue;
                    requestLaunchTemplateData.cpuOptions(LaunchTemplateCpuOptionsRequestUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            requestLaunchTemplateData.blockDeviceMappings(blockDeviceMappings);
            requestLaunchTemplateData.networkInterfaces(networkInterfaces);
            requestLaunchTemplateData.tagSpecifications(tagSpecifications);
            requestLaunchTemplateData.elasticGpuSpecifications(elasticGpuSpecifications);
            requestLaunchTemplateData.securityGroupIds(securityGroupIds);
            requestLaunchTemplateData.securityGroups(securityGroups);
        }
        return (RequestLaunchTemplateData)requestLaunchTemplateData.build();
    }

    public static RequestLaunchTemplateDataUnmarshaller getInstance() {
        return INSTANCE;
    }
}

