/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ReplaceRouteRequest;

public class ReplaceRouteRequestMarshaller
implements Marshaller<Request<ReplaceRouteRequest>, ReplaceRouteRequest> {
    public Request<ReplaceRouteRequest> marshall(ReplaceRouteRequest replaceRouteRequest) {
        if (replaceRouteRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)replaceRouteRequest, "Ec2Client");
        request.addParameter("Action", "ReplaceRoute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (replaceRouteRequest.destinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringConversion.fromString((String)replaceRouteRequest.destinationCidrBlock()));
        }
        if (replaceRouteRequest.destinationIpv6CidrBlock() != null) {
            request.addParameter("DestinationIpv6CidrBlock", StringConversion.fromString((String)replaceRouteRequest.destinationIpv6CidrBlock()));
        }
        if (replaceRouteRequest.egressOnlyInternetGatewayId() != null) {
            request.addParameter("EgressOnlyInternetGatewayId", StringConversion.fromString((String)replaceRouteRequest.egressOnlyInternetGatewayId()));
        }
        if (replaceRouteRequest.gatewayId() != null) {
            request.addParameter("GatewayId", StringConversion.fromString((String)replaceRouteRequest.gatewayId()));
        }
        if (replaceRouteRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)replaceRouteRequest.instanceId()));
        }
        if (replaceRouteRequest.natGatewayId() != null) {
            request.addParameter("NatGatewayId", StringConversion.fromString((String)replaceRouteRequest.natGatewayId()));
        }
        if (replaceRouteRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringConversion.fromString((String)replaceRouteRequest.networkInterfaceId()));
        }
        if (replaceRouteRequest.routeTableId() != null) {
            request.addParameter("RouteTableId", StringConversion.fromString((String)replaceRouteRequest.routeTableId()));
        }
        if (replaceRouteRequest.vpcPeeringConnectionId() != null) {
            request.addParameter("VpcPeeringConnectionId", StringConversion.fromString((String)replaceRouteRequest.vpcPeeringConnectionId()));
        }
        return request;
    }
}

