/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.ModifySpotFleetRequestRequest;

public class ModifySpotFleetRequestRequestMarshaller
implements Marshaller<Request<ModifySpotFleetRequestRequest>, ModifySpotFleetRequestRequest> {
    public Request<ModifySpotFleetRequestRequest> marshall(ModifySpotFleetRequestRequest modifySpotFleetRequestRequest) {
        if (modifySpotFleetRequestRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifySpotFleetRequestRequest, "Ec2Client");
        request.addParameter("Action", "ModifySpotFleetRequest");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySpotFleetRequestRequest.excessCapacityTerminationPolicyAsString() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringConversion.fromString((String)modifySpotFleetRequestRequest.excessCapacityTerminationPolicyAsString()));
        }
        if (modifySpotFleetRequestRequest.spotFleetRequestId() != null) {
            request.addParameter("SpotFleetRequestId", StringConversion.fromString((String)modifySpotFleetRequestRequest.spotFleetRequestId()));
        }
        if (modifySpotFleetRequestRequest.targetCapacity() != null) {
            request.addParameter("TargetCapacity", StringConversion.fromInteger((Integer)modifySpotFleetRequestRequest.targetCapacity()));
        }
        return request;
    }
}

