/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.InstanceCreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceCreditSpecificationRequest;

public class ModifyInstanceCreditSpecificationRequestMarshaller
implements Marshaller<Request<ModifyInstanceCreditSpecificationRequest>, ModifyInstanceCreditSpecificationRequest> {
    public Request<ModifyInstanceCreditSpecificationRequest> marshall(ModifyInstanceCreditSpecificationRequest modifyInstanceCreditSpecificationRequest) {
        List<InstanceCreditSpecificationRequest> modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsList;
        if (modifyInstanceCreditSpecificationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyInstanceCreditSpecificationRequest, "Ec2Client");
        request.addParameter("Action", "ModifyInstanceCreditSpecification");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstanceCreditSpecificationRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringConversion.fromString((String)modifyInstanceCreditSpecificationRequest.clientToken()));
        }
        if (!(modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsList = modifyInstanceCreditSpecificationRequest.instanceCreditSpecifications()).isEmpty() || !(modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsList instanceof SdkAutoConstructList)) {
            int instanceCreditSpecificationsListIndex = 1;
            for (InstanceCreditSpecificationRequest modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue : modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsList) {
                if (modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue.instanceId() != null) {
                    request.addParameter("InstanceCreditSpecification." + instanceCreditSpecificationsListIndex + ".InstanceId", StringConversion.fromString((String)modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue.instanceId()));
                }
                if (modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue.cpuCredits() != null) {
                    request.addParameter("InstanceCreditSpecification." + instanceCreditSpecificationsListIndex + ".CpuCredits", StringConversion.fromString((String)modifyInstanceCreditSpecificationRequestInstanceCreditSpecificationsListValue.cpuCredits()));
                }
                ++instanceCreditSpecificationsListIndex;
            }
        }
        return request;
    }
}

