/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.LoadPermissionModifications;
import software.amazon.awssdk.services.ec2.model.LoadPermissionRequest;
import software.amazon.awssdk.services.ec2.model.ModifyFpgaImageAttributeRequest;

public class ModifyFpgaImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyFpgaImageAttributeRequest>, ModifyFpgaImageAttributeRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<ModifyFpgaImageAttributeRequest> marshall(ModifyFpgaImageAttributeRequest modifyFpgaImageAttributeRequest) {
        LoadPermissionModifications loadPermissionModifications;
        List<String> modifyFpgaImageAttributeRequestProductCodesList;
        List<String> modifyFpgaImageAttributeRequestUserGroupsList;
        List<String> modifyFpgaImageAttributeRequestUserIdsList;
        if (modifyFpgaImageAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyFpgaImageAttributeRequest, "Ec2Client");
        request.addParameter("Action", "ModifyFpgaImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyFpgaImageAttributeRequest.fpgaImageId() != null) {
            request.addParameter("FpgaImageId", StringConversion.fromString((String)modifyFpgaImageAttributeRequest.fpgaImageId()));
        }
        if (modifyFpgaImageAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringConversion.fromString((String)modifyFpgaImageAttributeRequest.attributeAsString()));
        }
        if (modifyFpgaImageAttributeRequest.operationTypeAsString() != null) {
            request.addParameter("OperationType", StringConversion.fromString((String)modifyFpgaImageAttributeRequest.operationTypeAsString()));
        }
        if (!(modifyFpgaImageAttributeRequestUserIdsList = modifyFpgaImageAttributeRequest.userIds()).isEmpty() || !(modifyFpgaImageAttributeRequestUserIdsList instanceof SdkAutoConstructList)) {
            int userIdsListIndex = 1;
            for (String string : modifyFpgaImageAttributeRequestUserIdsList) {
                if (string != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringConversion.fromString((String)string));
                }
                ++userIdsListIndex;
            }
        }
        if (!(modifyFpgaImageAttributeRequestUserGroupsList = modifyFpgaImageAttributeRequest.userGroups()).isEmpty() || !(modifyFpgaImageAttributeRequestUserGroupsList instanceof SdkAutoConstructList)) {
            int userGroupsListIndex = 1;
            for (String string : modifyFpgaImageAttributeRequestUserGroupsList) {
                if (string != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringConversion.fromString((String)string));
                }
                ++userGroupsListIndex;
            }
        }
        if (!(modifyFpgaImageAttributeRequestProductCodesList = modifyFpgaImageAttributeRequest.productCodes()).isEmpty() || !(modifyFpgaImageAttributeRequestProductCodesList instanceof SdkAutoConstructList)) {
            boolean bl = true;
            for (String modifyFpgaImageAttributeRequestProductCodesListValue : modifyFpgaImageAttributeRequestProductCodesList) {
                void var6_12;
                if (modifyFpgaImageAttributeRequestProductCodesListValue != null) {
                    request.addParameter("ProductCode." + (int)var6_12, StringConversion.fromString((String)modifyFpgaImageAttributeRequestProductCodesListValue));
                }
                ++var6_12;
            }
        }
        if ((loadPermissionModifications = modifyFpgaImageAttributeRequest.loadPermission()) != null) {
            List<LoadPermissionRequest> loadPermissionModificationsRemoveList;
            List<LoadPermissionRequest> list = loadPermissionModifications.add();
            if (!list.isEmpty() || !(list instanceof SdkAutoConstructList)) {
                int addListIndex = 1;
                for (LoadPermissionRequest loadPermissionModificationsAddListValue : list) {
                    if (loadPermissionModificationsAddListValue.groupAsString() != null) {
                        request.addParameter("LoadPermission.Add." + addListIndex + ".Group", StringConversion.fromString((String)loadPermissionModificationsAddListValue.groupAsString()));
                    }
                    if (loadPermissionModificationsAddListValue.userId() != null) {
                        request.addParameter("LoadPermission.Add." + addListIndex + ".UserId", StringConversion.fromString((String)loadPermissionModificationsAddListValue.userId()));
                    }
                    ++addListIndex;
                }
            }
            if (!(loadPermissionModificationsRemoveList = loadPermissionModifications.remove()).isEmpty() || !(loadPermissionModificationsRemoveList instanceof SdkAutoConstructList)) {
                int removeListIndex = 1;
                for (LoadPermissionRequest loadPermissionModificationsRemoveListValue : loadPermissionModificationsRemoveList) {
                    if (loadPermissionModificationsRemoveListValue.groupAsString() != null) {
                        request.addParameter("LoadPermission.Remove." + removeListIndex + ".Group", StringConversion.fromString((String)loadPermissionModificationsRemoveListValue.groupAsString()));
                    }
                    if (loadPermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("LoadPermission.Remove." + removeListIndex + ".UserId", StringConversion.fromString((String)loadPermissionModificationsRemoveListValue.userId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyFpgaImageAttributeRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)modifyFpgaImageAttributeRequest.description()));
        }
        if (modifyFpgaImageAttributeRequest.name() != null) {
            request.addParameter("Name", StringConversion.fromString((String)modifyFpgaImageAttributeRequest.name()));
        }
        return request;
    }
}

