/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.EnableVolumeIoRequest;

public class EnableVolumeIoRequestMarshaller
implements Marshaller<Request<EnableVolumeIoRequest>, EnableVolumeIoRequest> {
    public Request<EnableVolumeIoRequest> marshall(EnableVolumeIoRequest enableVolumeIoRequest) {
        if (enableVolumeIoRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)enableVolumeIoRequest, "Ec2Client");
        request.addParameter("Action", "EnableVolumeIO");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableVolumeIoRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringConversion.fromString((String)enableVolumeIoRequest.volumeId()));
        }
        return request;
    }
}

