/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpnConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpnConnectionsRequest>, DescribeVpnConnectionsRequest> {
    public Request<DescribeVpnConnectionsRequest> marshall(DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        List<String> describeVpnConnectionsRequestVpnConnectionIdsList;
        if (describeVpnConnectionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpnConnectionsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpnConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<Filter> describeVpnConnectionsRequestFiltersList = describeVpnConnectionsRequest.filters();
        if (!describeVpnConnectionsRequestFiltersList.isEmpty() || !(describeVpnConnectionsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpnConnectionsRequestFiltersListValue : describeVpnConnectionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpnConnectionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpnConnectionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpnConnectionsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpnConnectionsRequestVpnConnectionIdsList = describeVpnConnectionsRequest.vpnConnectionIds()).isEmpty() || !(describeVpnConnectionsRequestVpnConnectionIdsList instanceof SdkAutoConstructList)) {
            int vpnConnectionIdsListIndex = 1;
            for (String describeVpnConnectionsRequestVpnConnectionIdsListValue : describeVpnConnectionsRequestVpnConnectionIdsList) {
                if (describeVpnConnectionsRequestVpnConnectionIdsListValue != null) {
                    request.addParameter("VpnConnectionId." + vpnConnectionIdsListIndex, StringConversion.fromString((String)describeVpnConnectionsRequestVpnConnectionIdsListValue));
                }
                ++vpnConnectionIdsListIndex;
            }
        }
        return request;
    }
}

