/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVpcEndpointServicePermissionsRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointServicePermissionsRequest>, DescribeVpcEndpointServicePermissionsRequest> {
    public Request<DescribeVpcEndpointServicePermissionsRequest> marshall(DescribeVpcEndpointServicePermissionsRequest describeVpcEndpointServicePermissionsRequest) {
        List<Filter> describeVpcEndpointServicePermissionsRequestFiltersList;
        if (describeVpcEndpointServicePermissionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeVpcEndpointServicePermissionsRequest, "Ec2Client");
        request.addParameter("Action", "DescribeVpcEndpointServicePermissions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVpcEndpointServicePermissionsRequest.serviceId() != null) {
            request.addParameter("ServiceId", StringConversion.fromString((String)describeVpcEndpointServicePermissionsRequest.serviceId()));
        }
        if (!(describeVpcEndpointServicePermissionsRequestFiltersList = describeVpcEndpointServicePermissionsRequest.filters()).isEmpty() || !(describeVpcEndpointServicePermissionsRequestFiltersList instanceof SdkAutoConstructList)) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointServicePermissionsRequestFiltersListValue : describeVpcEndpointServicePermissionsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVpcEndpointServicePermissionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)describeVpcEndpointServicePermissionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = describeVpcEndpointServicePermissionsRequestFiltersListValue.values()).isEmpty() || !(filterValuesList instanceof SdkAutoConstructList)) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringConversion.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointServicePermissionsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringConversion.fromInteger((Integer)describeVpcEndpointServicePermissionsRequest.maxResults()));
        }
        if (describeVpcEndpointServicePermissionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeVpcEndpointServicePermissionsRequest.nextToken()));
        }
        return request;
    }
}

